/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.LambdaToMethod;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.tools.Diagnostic;
import manifold.api.type.ICompilerComponent;
import manifold.internal.javac.GeneratedJavaStubFileObject;
import manifold.internal.javac.JavacPlugin;
import manifold.rt.api.util.Stack;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class ManLog_8
extends Log {
    private final Map<Log.DiagnosticHandler, LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>>> _suspendedIssues;
    private final LocklessLazyVar<Class<?>> _extensionTransformerClass;

    public static Log instance(Context ctx) {
        Log log = (Log)ctx.get(logKey);
        if (!(log instanceof ManLog_8)) {
            ctx.put(logKey, (Log)null);
            log = new ManLog_8(ctx, (Log.DiagnosticHandler)ReflectUtil.field(log, "diagnosticHandler").get(), log.currentSource(), (PrintWriter)ReflectUtil.field(log, "errWriter").get(), (PrintWriter)ReflectUtil.field(log, "warnWriter").get(), (PrintWriter)ReflectUtil.field(log, "noticeWriter").get());
        }
        return log;
    }

    private ManLog_8(Context ctx, Log.DiagnosticHandler diagnosticHandler, DiagnosticSource source, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        super(ctx, errWriter, warnWriter, noticeWriter);
        ReflectUtil.field(this, "diagnosticHandler").set(diagnosticHandler);
        this.ensureDiagnosticHandlersEnclosingClassIsThis(diagnosticHandler);
        ReflectUtil.field(this, "source").set(source);
        this._suspendedIssues = new HashMap<Log.DiagnosticHandler, LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>>>();
        this._extensionTransformerClass = LocklessLazyVar.make(() -> ReflectUtil.type("manifold.ext.ExtensionTransformer"));
        this.reassignLog(ctx);
    }

    private void ensureDiagnosticHandlersEnclosingClassIsThis(Log.DiagnosticHandler diagnosticHandler) {
        try {
            ReflectUtil.field(diagnosticHandler, "this$0").set(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reassignLog(Context ctx) {
        Object[] earlyAttrHolders;
        for (Object instance : earlyAttrHolders = new Object[]{Annotate.instance(ctx), Check.instance(ctx), ClassReader.instance(ctx), ClassWriter.instance(ctx), DeferredAttr.instance(ctx), Enter.instance(ctx), Flow.instance(ctx), Gen.instance(ctx), Infer.instance(ctx), JavaCompiler.instance(ctx), JavacProcessingEnvironment.instance(ctx), JavacProcessingEnvironment.instance(ctx).getMessager(), JavacTrees.instance(ctx), MemberEnter.instance(ctx), Resolve.instance(ctx), LambdaToMethod.instance(ctx), Lower.instance(ctx), MemberEnter.instance(ctx), TransTypes.instance(ctx), TypeAnnotations.instance(ctx)}) {
            ReflectUtil.LiveFieldRef l = ReflectUtil.WithNull.field(instance, "log");
            if (l == null) continue;
            l.set(this);
        }
        for (Field f : Check.class.getDeclaredFields()) {
            if (!MandatoryWarningHandler.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            try {
                Object mwh = f.get(Check.instance(ctx));
                ReflectUtil.field(mwh, "log").set(this);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void popDiagnosticHandler(Log.DiagnosticHandler handler) {
        super.popDiagnosticHandler(handler);
        this._suspendedIssues.remove(handler);
        Log.DiagnosticHandler diagnosticHandler = (Log.DiagnosticHandler)ReflectUtil.field(this, "diagnosticHandler").get();
        this.ensureDiagnosticHandlersEnclosingClassIsThis(diagnosticHandler);
    }

    public void error(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        if (!(pos instanceof JCTree.JCFieldAccess && ("cant.assign.val.to.final.var".equals(key) || "var.might.already.be.assigned".equals(key)) && this.isJailbreakSelect((JCTree.JCFieldAccess)pos) || this.isSuppressed(pos, key, args))) {
            super.error(pos, key, args);
        }
    }

    public void warning(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        if (!this.isSuppressed(pos, key, args)) {
            super.warning(pos, key, args);
        }
    }

    private boolean isSuppressed(JCDiagnostic.DiagnosticPosition pos, String key, Object[] args) {
        for (ICompilerComponent cc : JavacPlugin.instance().getTypeProcessor().getCompilerComponents()) {
            if (!cc.isSuppressed(pos, key, args)) continue;
            return true;
        }
        return false;
    }

    private Log.DiagnosticHandler getDiagnosticHandler() {
        return (Log.DiagnosticHandler)ReflectUtil.field(this, "diagnosticHandler").get();
    }

    @Override
    public void report(JCDiagnostic issue) {
        if (ManLog_8.isWarningInGeneratedSource(issue) || this.isPrivateJdkCtorIssue(issue)) {
            return;
        }
        if (this.isSuppressed(issue.getDiagnosticPosition(), issue.getCode(), issue.getArgs())) {
            return;
        }
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        if (suspendedIssues == null || suspendedIssues.isEmpty()) {
            super.report(issue);
        } else {
            JCTree last = null;
            Iterator<JCTree> iterator = suspendedIssues.keySet().iterator();
            while (iterator.hasNext()) {
                JCTree key;
                last = key = iterator.next();
            }
            suspendedIssues.get(last).peek().push(issue);
        }
    }

    private static boolean isWarningInGeneratedSource(JCDiagnostic issue) {
        return issue.getKind().ordinal() > Diagnostic.Kind.ERROR.ordinal() && issue.getDiagnosticSource().getFile() instanceof GeneratedJavaStubFileObject;
    }

    private boolean isPrivateJdkCtorIssue(JCDiagnostic issue) {
        return JavacPlugin.instance() != null && issue.getCode() != null && issue.getCode().endsWith("cant.apply.symbol") && this.source.getFile() instanceof GeneratedJavaStubFileObject;
    }

    boolean isJailbreakSelect(JCTree.JCFieldAccess pos) {
        if (this._extensionTransformerClass.get() == null) {
            return false;
        }
        return (Boolean)ReflectUtil.method(this._extensionTransformerClass.get(), "isJailbreakReceiver", JCTree.JCFieldAccess.class).invokeStatic(pos);
    }

    void pushSuspendIssues(JCTree tree) {
        LinkedHashMap suspendedIssues = this._suspendedIssues.computeIfAbsent(this.getDiagnosticHandler(), k -> new LinkedHashMap());
        Stack issues = (Stack)suspendedIssues.get(tree);
        if (issues == null) {
            issues = new Stack();
            suspendedIssues.put(tree, issues);
        }
        issues.push(new Stack());
    }

    void popSuspendIssues(JCTree tree) {
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        if (suspendedIssues.isEmpty()) {
            return;
        }
        Stack<Stack<JCDiagnostic>> issueFrames = suspendedIssues.get(tree);
        if (issueFrames.size() == 1) {
            if (this.isRootFrame(tree)) {
                this.recordRecentSuspendedIssuesAndRemoveOthers(tree);
            }
        } else {
            issueFrames.pop();
        }
    }

    void recordRecentSuspendedIssuesAndRemoveOthers(JCTree tree) {
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        Stack<Stack<JCDiagnostic>> issues = suspendedIssues.get(tree);
        Stack<JCDiagnostic> currentIssues = issues.pop();
        issues.clear();
        issues.push(currentIssues);
        if (this.isRootFrame(tree)) {
            this.recordSuspendedIssues();
            suspendedIssues.clear();
        }
    }

    private void recordSuspendedIssues() {
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        for (Map.Entry<JCTree, Stack<Stack<JCDiagnostic>>> entry : suspendedIssues.entrySet()) {
            Stack<Stack<JCDiagnostic>> issueFrames = entry.getValue();
            Stack<JCDiagnostic> issueFrame = issueFrames.pop();
            if (!issueFrames.isEmpty()) {
                throw new IllegalStateException("Invalid issue frames, should be only one frame");
            }
            for (JCDiagnostic d : issueFrame) {
                super.report(d);
            }
        }
    }

    private boolean isRootFrame(JCTree tree) {
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        return suspendedIssues.keySet().iterator().next() == tree;
    }
}

