/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.runtime;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import manifold.internal.runtime.ManModuleReader;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class UrlClassLoaderWrapper {
    private static final Set<Integer> VISITED_LOADER_IDS = new HashSet<Integer>();
    private final ClassLoader _loader;
    private final ReflectUtil.LiveMethodRef _getURLs;
    private final ReflectUtil.LiveMethodRef _addUrl;

    static UrlClassLoaderWrapper wrapIfNotAlreadyVisited(ClassLoader loader) {
        int loaderId = System.identityHashCode(loader);
        if (VISITED_LOADER_IDS.contains(loaderId)) {
            return null;
        }
        VISITED_LOADER_IDS.add(loaderId);
        UrlClassLoaderWrapper wrapped = UrlClassLoaderWrapper.wrap(loader);
        if (wrapped == null) {
            throw new IllegalStateException("Could not wrap loader: " + loader.getClass().getName());
        }
        return wrapped;
    }

    public static boolean canWrap(ClassLoader loader) {
        ReflectUtil.LiveMethodRef getURLs = UrlClassLoaderWrapper.getURLsMethod(loader);
        if (getURLs != null) {
            ReflectUtil.LiveMethodRef addUrl = ReflectUtil.WithNull.method(getURLs.getReceiver(), "addURL|addUrl", URL.class);
            return addUrl != null;
        }
        return false;
    }

    public static UrlClassLoaderWrapper wrap(ClassLoader loader) {
        ReflectUtil.LiveMethodRef addUrl;
        ReflectUtil.LiveMethodRef getURLs = UrlClassLoaderWrapper.getURLsMethod(loader);
        if (getURLs != null && (addUrl = ReflectUtil.WithNull.method(getURLs.getReceiver(), "addURL|addUrl", URL.class)) != null) {
            return new UrlClassLoaderWrapper(loader, getURLs, addUrl);
        }
        return null;
    }

    private static ReflectUtil.LiveMethodRef getURLsMethod(Object receiver) {
        Object ucp;
        ReflectUtil.LiveFieldRef ucpField;
        ReflectUtil.LiveMethodRef getURLs = ReflectUtil.WithNull.methodWithReturn(receiver, "getURLs|getUrls", URL[].class, new Class[0]);
        if (getURLs == null && (getURLs = ReflectUtil.WithNull.methodWithReturn(receiver, "getURLs|getUrls", List.class, new Class[0])) == null && receiver instanceof ClassLoader && (ucpField = ReflectUtil.WithNull.field(receiver, "ucp")) != null && (ucp = ucpField.get()) != null) {
            getURLs = UrlClassLoaderWrapper.getURLsMethod(ucp);
        }
        return getURLs;
    }

    private UrlClassLoaderWrapper(ClassLoader loader, ReflectUtil.LiveMethodRef getURLs, ReflectUtil.LiveMethodRef addUrl) {
        this._loader = loader;
        this._getURLs = getURLs;
        this._addUrl = addUrl;
    }

    public ClassLoader getLoader() {
        return this._loader;
    }

    void addURL(URL url) {
        try {
            this._addUrl.invoke(url);
            if (JreUtil.isJava9Modular_runtime()) {
                this.wrapReaders();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void wrapReaders() {
        Map moduleToReader = (Map)ReflectUtil.field(this._loader, "moduleToReader").get();
        for (Object mr : moduleToReader.keySet()) {
            String scheme;
            Optional location = (Optional)ReflectUtil.method(mr, "location", new Class[0]).invoke(new Object[0]);
            URI uri = location.orElse(null);
            if (uri == null || !(scheme = uri.getScheme()).equalsIgnoreCase("file") && !scheme.equalsIgnoreCase("jar")) continue;
            Object reader = moduleToReader.get(mr);
            Class<?> moduleReaderClass = ReflectUtil.type("java.lang.module.ModuleReader");
            ManModuleReader wrapper = new ManModuleReader(reader, ReflectUtil.field(this._loader, "ucp").get());
            Object proxy = Proxy.newProxyInstance(moduleReaderClass.getClassLoader(), new Class[]{moduleReaderClass}, (InvocationHandler)new ManModuleReaderInvocationHandler(wrapper));
            moduleToReader.put(mr, proxy);
        }
    }

    public List<URL> getURLs() {
        if (this._loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)this._loader).getURLs();
            return urls == null ? Collections.emptyList() : Arrays.asList(urls);
        }
        ArrayList<URL> allUrls = new ArrayList<URL>(this.getClasspathUrls());
        if (JreUtil.isJava9Modular_runtime()) {
            allUrls.addAll(this.getModularUrls());
        }
        return Collections.unmodifiableList(allUrls);
    }

    private Set<URL> getModularUrls() {
        ReflectUtil.LiveFieldRef nameToModuleField;
        try {
            nameToModuleField = ReflectUtil.field(this._loader, "nameToModule");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashSet<URL> modulePath = new HashSet<URL>();
        Map nameToModule = (Map)nameToModuleField.get();
        for (Object mr : nameToModule.values()) {
            String scheme;
            Optional location = (Optional)ReflectUtil.method(mr, "location", new Class[0]).invoke(new Object[0]);
            URI uri = location.orElse(null);
            if (uri == null || !(scheme = uri.getScheme()).equalsIgnoreCase("file") && !scheme.equalsIgnoreCase("jar")) continue;
            try {
                modulePath.add(new File(uri).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return modulePath;
    }

    private List<URL> getClasspathUrls() {
        try {
            List<URL> urls = this._getURLs.invoke(new Object[0]);
            urls = urls == null ? Collections.emptyList() : (urls.getClass().isArray() ? Arrays.asList((URL[])urls) : urls);
            return urls;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ManModuleReaderInvocationHandler
    implements InvocationHandler {
        private final Object _wrapper;

        private ManModuleReaderInvocationHandler(Object wrapper) {
            this._wrapper = wrapper;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            return ReflectUtil.method(this._wrapper, method.getName(), (Class[])method.getParameterTypes()).invoke(args);
        }
    }
}

