/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.runtime.protocols;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import manifold.internal.runtime.protocols.ManClassesUrlConnection;

public class Handler
extends URLStreamHandler {
    public static final ConcurrentHashMap<URL, URL> _visited = new ConcurrentHashMap();
    public static final Handler INSTANCE = new Handler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        if (_visited.containsKey(u)) {
            return null;
        }
        _visited.put(u, u);
        try {
            ManClassesUrlConnection connection = new ManClassesUrlConnection(u);
            ManClassesUrlConnection manClassesUrlConnection = connection.isValid() ? connection : null;
            return manClassesUrlConnection;
        }
        finally {
            _visited.remove(u);
        }
    }

    @Override
    protected int hashCode(URL u) {
        return (u.getProtocol() + u.getHost() + u.getPath()).hashCode();
    }

    @Override
    protected boolean equals(URL u1, URL u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return (u1.getProtocol() + u1.getHost() + u1.getPath()).equals(u2.getProtocol() + u2.getHost() + u2.getPath());
    }

    static {
        Arrays.asList(ManClassesUrlConnection.class, ManClassesUrlConnection.LazyByteArrayInputStream.class);
    }
}

