/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Current;
import manifold.science.measures.Inductance;
import manifold.science.measures.InductanceUnit;
import manifold.science.measures.Potential;
import manifold.science.measures.PotentialUnit;
import manifold.science.measures.ResistanceUnit;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.util.Rational;

public final class Resistance
extends AbstractMeasure<ResistanceUnit, Resistance> {
    public Resistance(Rational value, ResistanceUnit unit, ResistanceUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Resistance(Rational value, ResistanceUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public ResistanceUnit getBaseUnit() {
        return ResistanceUnit.BASE;
    }

    @Override
    public Resistance make(Rational value, ResistanceUnit unit, ResistanceUnit displayUnit) {
        return new Resistance(value, unit, displayUnit);
    }

    @Override
    public Resistance make(Rational value, ResistanceUnit unit) {
        return new Resistance(value, unit);
    }

    public Potential times(Current current) {
        return new Potential(this.toBaseNumber().times(current.toBaseNumber()), PotentialUnit.BASE, ((ResistanceUnit)this.getDisplayUnit()).getPotentialUnit());
    }

    public Inductance times(Time time) {
        return new Inductance(this.toBaseNumber().times(time.toBaseNumber()), InductanceUnit.BASE, ((ResistanceUnit)this.getDisplayUnit()).times((TimeUnit)time.getDisplayUnit()));
    }
}

