/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import java.math.BigInteger;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.List;
import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Acceleration;
import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.Angle;
import manifold.science.measures.AngleUnit;
import manifold.science.measures.Charge;
import manifold.science.measures.ChargeUnit;
import manifold.science.measures.Current;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.Energy;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.Force;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.Frequency;
import manifold.science.measures.FrequencyUnit;
import manifold.science.measures.Length;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.Momentum;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.Power;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.Velocity;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.Rational;

public final class Time
extends AbstractMeasure<TimeUnit, Time>
implements TemporalAmount {
    public Time(Rational value, TimeUnit unit, TimeUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Time(Rational value, TimeUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public TimeUnit getBaseUnit() {
        return TimeUnit.BASE;
    }

    @Override
    public Time make(Rational value, TimeUnit unit, TimeUnit displayUnit) {
        return new Time(value, unit, displayUnit);
    }

    @Override
    public Time make(Rational value, TimeUnit unit) {
        return new Time(value, unit, unit);
    }

    public static Time now() {
        return new Time(Rational.get(System.nanoTime()), TimeUnit.Nano);
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.SECONDS) {
            return this.toBaseNumber().wholePart().longValue();
        }
        if (unit == ChronoUnit.NANOS) {
            return this.toBaseNumber().fractionPart().times(1.0E9).longValue();
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return this.getBaseUnit().getDuration().getUnits();
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        Rational fractionPart;
        BigInteger wholePart = this.toBaseNumber().wholePart();
        if (!wholePart.equals(BigInteger.ZERO)) {
            temporal = temporal.plus(wholePart.longValue(), ChronoUnit.SECONDS);
        }
        if (!(fractionPart = this.toBaseNumber().fractionPart()).equals(Rational.ZERO)) {
            temporal = temporal.plus(fractionPart.times(1.0E9).longValue(), ChronoUnit.NANOS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Rational fractionPart;
        BigInteger wholePart = this.toBaseNumber().wholePart();
        if (!wholePart.equals(BigInteger.ZERO)) {
            temporal = temporal.minus(wholePart.longValue(), ChronoUnit.SECONDS);
        }
        if (!(fractionPart = this.toBaseNumber().fractionPart()).equals(Rational.ZERO)) {
            temporal = temporal.minus(fractionPart.times(1.0E9).longValue(), ChronoUnit.NANOS);
        }
        return temporal;
    }

    public Length times(Velocity r) {
        return new Length(this.toBaseNumber().times(r.toBaseNumber()), LengthUnit.BASE, ((VelocityUnit)r.getDisplayUnit()).getLengthUnit());
    }

    public Velocity times(Acceleration acc) {
        return new Velocity(this.toBaseNumber().times(acc.toBaseNumber()), VelocityUnit.BASE, ((AccelerationUnit)acc.getDisplayUnit()).getVelocityUnit());
    }

    public Charge times(Current current) {
        return new Charge(this.toBaseNumber().times(current.toBaseNumber()), ChargeUnit.BASE, ((CurrentUnit)current.getDisplayUnit()).getChargeUnit());
    }

    public Angle times(Frequency frequency) {
        return new Angle(this.toBaseNumber().times(frequency.toBaseNumber()), AngleUnit.BASE, ((FrequencyUnit)frequency.getDisplayUnit()).getAngleUnit());
    }

    public Energy times(Power power) {
        return new Energy(this.toBaseNumber().times(power.toBaseNumber()), EnergyUnit.BASE, ((PowerUnit)power.getDisplayUnit()).getEnergyUnit());
    }

    public Momentum times(Force force) {
        return new Momentum(this.toBaseNumber().times(force.toBaseNumber()), MomentumUnit.BASE, ((TimeUnit)this.getDisplayUnit()).times((ForceUnit)force.getDisplayUnit()));
    }
}

