/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import manifold.science.util.Rational;

public interface CoercionConstants {
    public static final RationalCoercion r = RationalCoercion.INSTANCE;
    public static final BigDecimalCoercion bd = BigDecimalCoercion.INSTANCE;
    public static final BigIntegerCoercion bi = BigIntegerCoercion.INSTANCE;

    public static class BigIntegerCoercion {
        static final BigIntegerCoercion INSTANCE = new BigIntegerCoercion();

        public BigInteger postfixBind(String value) {
            return new BigInteger(value);
        }

        public BigInteger postfixBind(Integer value) {
            return BigInteger.valueOf(value.intValue());
        }

        public BigInteger postfixBind(Long value) {
            return BigInteger.valueOf(value);
        }
    }

    public static class BigDecimalCoercion {
        static final BigDecimalCoercion INSTANCE = new BigDecimalCoercion();

        public BigDecimal postfixBind(String value) {
            return new BigDecimal(value);
        }

        public BigDecimal postfixBind(Integer value) {
            return BigDecimal.valueOf(value.intValue());
        }

        public BigDecimal postfixBind(Long value) {
            return BigDecimal.valueOf(value);
        }

        public BigDecimal postfixBind(Float value) {
            return BigDecimal.valueOf(value.floatValue());
        }

        public BigDecimal postfixBind(Double value) {
            return BigDecimal.valueOf(value);
        }

        public BigDecimal postfixBind(BigInteger value) {
            return new BigDecimal(value);
        }
    }

    public static class RationalCoercion {
        static final RationalCoercion INSTANCE = new RationalCoercion();

        public Rational postfixBind(String value) {
            return Rational.get(value);
        }

        public Rational postfixBind(Integer value) {
            return Rational.get(value);
        }

        public Rational postfixBind(Long value) {
            return Rational.get(value);
        }

        public Rational postfixBind(Float value) {
            return Rational.get(value);
        }

        public Rational postfixBind(Double value) {
            return Rational.get(value);
        }

        public Rational postfixBind(BigInteger value) {
            return Rational.get(value);
        }

        public Rational postfixBind(BigDecimal value) {
            return Rational.get(value);
        }
    }
}

