/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.dataloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import manifold.shade.org.dataloader.DataLoader;
import manifold.shade.org.dataloader.annotations.PublicApi;
import manifold.shade.org.dataloader.stats.Statistics;

@PublicApi
public class DataLoaderRegistry {
    protected final Map<String, DataLoader<?, ?>> dataLoaders = new ConcurrentHashMap();

    public DataLoaderRegistry() {
    }

    private DataLoaderRegistry(Builder builder) {
        this.dataLoaders.putAll(builder.dataLoaders);
    }

    public DataLoaderRegistry register(String key, DataLoader<?, ?> dataLoader) {
        this.dataLoaders.put(key, dataLoader);
        return this;
    }

    public <K, V> DataLoader<K, V> computeIfAbsent(String key, Function<String, DataLoader<?, ?>> mappingFunction) {
        return this.dataLoaders.computeIfAbsent(key, mappingFunction);
    }

    public DataLoaderRegistry combine(DataLoaderRegistry registry) {
        DataLoaderRegistry combined = new DataLoaderRegistry();
        this.dataLoaders.forEach(combined::register);
        registry.dataLoaders.forEach(combined::register);
        return combined;
    }

    public List<DataLoader<?, ?>> getDataLoaders() {
        return new ArrayList(this.dataLoaders.values());
    }

    public Map<String, DataLoader<?, ?>> getDataLoadersMap() {
        return new LinkedHashMap(this.dataLoaders);
    }

    public DataLoaderRegistry unregister(String key) {
        this.dataLoaders.remove(key);
        return this;
    }

    public <K, V> DataLoader<K, V> getDataLoader(String key) {
        return this.dataLoaders.get(key);
    }

    public Set<String> getKeys() {
        return new HashSet<String>(this.dataLoaders.keySet());
    }

    public void dispatchAll() {
        this.getDataLoaders().forEach(DataLoader::dispatch);
    }

    public int dispatchAllWithCount() {
        int sum = 0;
        for (DataLoader<?, ?> dataLoader : this.getDataLoaders()) {
            sum += dataLoader.dispatchWithCounts().getKeysCount();
        }
        return sum;
    }

    public int dispatchDepth() {
        int totalDispatchDepth = 0;
        for (DataLoader<?, ?> dataLoader : this.getDataLoaders()) {
            totalDispatchDepth += dataLoader.dispatchDepth();
        }
        return totalDispatchDepth;
    }

    public Statistics getStatistics() {
        Statistics stats = new Statistics();
        for (DataLoader<?, ?> dataLoader : this.dataLoaders.values()) {
            stats = stats.combine(dataLoader.getStatistics());
        }
        return stats;
    }

    public static Builder newRegistry() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, DataLoader<?, ?>> dataLoaders = new HashMap();

        public Builder register(String key, DataLoader<?, ?> dataLoader) {
            this.dataLoaders.put(key, dataLoader);
            return this;
        }

        public Builder registerAll(DataLoaderRegistry otherRegistry) {
            this.dataLoaders.putAll(otherRegistry.dataLoaders);
            return this;
        }

        public DataLoaderRegistry build() {
            return new DataLoaderRegistry(this);
        }
    }
}

