/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.snakeyaml.engine.v1.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class CharConstants {
    private static final String ALPHA_S = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_";
    private static final String LINEBR_S = "\n\r";
    private static final String NULL_OR_LINEBR_S = "\u0000\n\r";
    private static final String NULL_BL_LINEBR_S = " \u0000\n\r";
    private static final String NULL_BL_T_LINEBR_S = "\t \u0000\n\r";
    private static final String NULL_BL_T_S = "\u0000 \t";
    private static final String URI_CHARS_S = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_-;/?:@&=+$,_.!~*'()[]%";
    public static final CharConstants LINEBR = new CharConstants("\n\r");
    public static final CharConstants NULL_OR_LINEBR = new CharConstants("\u0000\n\r");
    public static final CharConstants NULL_BL_LINEBR = new CharConstants(" \u0000\n\r");
    public static final CharConstants NULL_BL_T_LINEBR = new CharConstants("\t \u0000\n\r");
    public static final CharConstants NULL_BL_T = new CharConstants("\u0000 \t");
    public static final CharConstants URI_CHARS = new CharConstants("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_-;/?:@&=+$,_.!~*'()[]%");
    public static final CharConstants ALPHA = new CharConstants("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_");
    public static final Pattern ANCHOR_FORMAT = Pattern.compile("^[-_\\w]*$");
    private static final int ASCII_SIZE = 128;
    boolean[] contains = new boolean[128];
    public static final Map<Integer, Character> ESCAPE_REPLACEMENTS = new HashMap<Integer, Character>();
    public static final Map<Character, Integer> ESCAPES = new HashMap<Character, Integer>();
    public static final Map<Character, Integer> ESCAPE_CODES = new HashMap<Character, Integer>();

    private CharConstants(String content) {
        Arrays.fill(this.contains, false);
        for (int i = 0; i < content.length(); ++i) {
            int c = content.codePointAt(i);
            this.contains[c] = true;
        }
    }

    public boolean has(int c) {
        return c < 128 ? this.contains[c] : false;
    }

    public boolean hasNo(int c) {
        return !this.has(c);
    }

    public boolean has(int c, String additional) {
        return this.has(c) || additional.indexOf(c, 0) != -1;
    }

    public boolean hasNo(int c, String additional) {
        return !this.has(c, additional);
    }

    static {
        ESCAPE_REPLACEMENTS.put(48, Character.valueOf('\u0000'));
        ESCAPE_REPLACEMENTS.put(97, Character.valueOf('\u0007'));
        ESCAPE_REPLACEMENTS.put(98, Character.valueOf('\b'));
        ESCAPE_REPLACEMENTS.put(116, Character.valueOf('\t'));
        ESCAPE_REPLACEMENTS.put(110, Character.valueOf('\n'));
        ESCAPE_REPLACEMENTS.put(118, Character.valueOf('\u000b'));
        ESCAPE_REPLACEMENTS.put(102, Character.valueOf('\f'));
        ESCAPE_REPLACEMENTS.put(114, Character.valueOf('\r'));
        ESCAPE_REPLACEMENTS.put(101, Character.valueOf('\u001b'));
        ESCAPE_REPLACEMENTS.put(32, Character.valueOf(' '));
        ESCAPE_REPLACEMENTS.put(34, Character.valueOf('\"'));
        ESCAPE_REPLACEMENTS.put(47, Character.valueOf('/'));
        ESCAPE_REPLACEMENTS.put(92, Character.valueOf('\\'));
        ESCAPE_REPLACEMENTS.put(78, Character.valueOf('\u0085'));
        ESCAPE_REPLACEMENTS.put(95, Character.valueOf('\u00a0'));
        ESCAPE_REPLACEMENTS.put(76, Character.valueOf('\u2028'));
        ESCAPE_REPLACEMENTS.put(80, Character.valueOf('\u2029'));
        ESCAPE_REPLACEMENTS.entrySet().stream().filter(entry -> (Integer)entry.getKey() != 32 && (Integer)entry.getKey() != 47).forEach(entry -> ESCAPES.put((Character)entry.getValue(), (Integer)entry.getKey()));
        ESCAPE_CODES.put(Character.valueOf('x'), 2);
        ESCAPE_CODES.put(Character.valueOf('u'), 4);
        ESCAPE_CODES.put(Character.valueOf('U'), 8);
    }
}

