/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.snakeyaml.engine.v1.nodes;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import manifold.shade.org.snakeyaml.engine.v1.common.FlowStyle;
import manifold.shade.org.snakeyaml.engine.v1.exceptions.Mark;
import manifold.shade.org.snakeyaml.engine.v1.nodes.CollectionNode;
import manifold.shade.org.snakeyaml.engine.v1.nodes.Node;
import manifold.shade.org.snakeyaml.engine.v1.nodes.NodeType;
import manifold.shade.org.snakeyaml.engine.v1.nodes.Tag;

public class SequenceNode
extends CollectionNode<Node> {
    private final List<Node> value;

    public SequenceNode(Tag tag, boolean resolved, List<Node> value, FlowStyle flowStyle, Optional<Mark> startMark, Optional<Mark> endMark) {
        super(tag, flowStyle, startMark, endMark);
        Objects.requireNonNull(value, "value in a Node is required.");
        this.value = value;
        this.resolved = resolved;
    }

    public SequenceNode(Tag tag, List<Node> value, FlowStyle flowStyle) {
        this(tag, true, value, flowStyle, Optional.empty(), Optional.empty());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SEQUENCE;
    }

    @Override
    public List<Node> getValue() {
        return this.value;
    }

    public List<Node> getSequence() {
        return this.value;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", value=" + this.getValue() + ")>";
    }
}

