/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.rt.runtime;

import java.io.IOException;
import manifold.util.ManExceptionUtil;

public class WrapAppendable
implements Appendable {
    private final Appendable _appendable;
    private final StringBuilder _indentHolder;
    private final String _indentation;

    public WrapAppendable(Appendable appendable, String indentation) {
        this._indentation = indentation;
        this._appendable = appendable;
        this._indentHolder = new StringBuilder();
    }

    @Override
    public Appendable append(CharSequence csq) {
        try {
            return this.getAppendable().append(csq);
        }
        catch (IOException e) {
            throw ManExceptionUtil.unchecked(e);
        }
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        try {
            return this.getAppendable().append(csq, start, end);
        }
        catch (IOException e) {
            throw ManExceptionUtil.unchecked(e);
        }
    }

    @Override
    public Appendable append(char c) {
        try {
            return this.getAppendable().append(c);
        }
        catch (IOException e) {
            throw ManExceptionUtil.unchecked(e);
        }
    }

    void complete() {
        if (this._indentation.length() > 0) {
            this.indent(this._indentHolder);
        } else if (this._indentHolder.length() > 0) {
            throw new IllegalStateException("Indentation state is invalid");
        }
    }

    private Appendable getAppendable() {
        return this._indentation.length() == 0 ? this._appendable : this._indentHolder;
    }

    private void indent(CharSequence csq) {
        try {
            this._appendable.append(this._indentation);
            for (int i = 0; i < csq.length(); ++i) {
                char c = csq.charAt(i);
                this._appendable.append(c);
                if (c != '\n') continue;
                this._appendable.append(this._indentation);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

