/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Closeable;
import java.util.Iterator;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class IteratorLikeIterable
implements Iterable<Object>,
Closeable {
    private final Context cx;
    private final Scriptable scope;
    private final Callable next;
    private final Callable returnFunc;
    private final Scriptable iterator;
    private boolean closed;

    public IteratorLikeIterable(Context cx, Scriptable scope, Object target) {
        this.cx = cx;
        this.scope = scope;
        this.next = ScriptRuntime.getPropFunctionAndThis(target, "next", cx, scope);
        this.iterator = ScriptRuntime.lastStoredScriptable(cx);
        Scriptable st = ScriptableObject.ensureScriptable(target);
        if (st.has("return", st)) {
            this.returnFunc = ScriptRuntime.getPropFunctionAndThis(target, "return", cx, scope);
            ScriptRuntime.lastStoredScriptable(cx);
        } else {
            this.returnFunc = null;
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.returnFunc != null) {
                this.returnFunc.call(this.cx, this.scope, this.iterator, ScriptRuntime.emptyArgs);
            }
        }
    }

    public Itr iterator() {
        return new Itr();
    }

    public final class Itr
    implements Iterator<Object> {
        private Object nextVal;

        @Override
        public boolean hasNext() {
            Object val2 = IteratorLikeIterable.this.next.call(IteratorLikeIterable.this.cx, IteratorLikeIterable.this.scope, IteratorLikeIterable.this.iterator, ScriptRuntime.emptyArgs);
            Object doneval = ScriptRuntime.getObjectProp(val2, "done", IteratorLikeIterable.this.cx, IteratorLikeIterable.this.scope);
            if (Undefined.instance.equals(doneval)) {
                throw ScriptRuntime.undefReadError(val2, "done");
            }
            if (Boolean.TRUE.equals(doneval)) {
                return false;
            }
            this.nextVal = ScriptRuntime.getObjectProp(val2, "value", IteratorLikeIterable.this.cx, IteratorLikeIterable.this.scope);
            return true;
        }

        @Override
        public Object next() {
            return this.nextVal;
        }
    }
}

