/*
 * Decompiled with CFR 0.152.
 */
package mr;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.function.Predicate;
import manifold.api.fs.cache.PathCache;
import manifold.internal.host.ManifoldHost;
import manifold.internal.runtime.Bootstrap;
import manifold.templates.ManifoldTemplates;
import manifold.templates.runtime.ILayout;
import manifold.util.StreamUtil;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.lesscss.LessCompiler;
import www.layout.main;

public class Hyde {
    static Parser MD_PARSER;
    static HtmlRenderer MD_RENDERER;

    public static void main(String[] args) throws Exception {
        Hyde.log("Generating Site...");
        File outputDir = Hyde.makeOutputDir();
        File wwwDir = Hyde.fileFromResourcePath("/www");
        ManifoldTemplates.setDefaultLayout((ILayout)main.asLayout());
        PathCache pathCache = ManifoldHost.getCurrentModule().getPathCache();
        Hyde.log("Generating Templates...");
        for (String fqn : pathCache.getExtensionCache("mtf").getFqns()) {
            File f;
            if (fqn.contains(".layout.")) continue;
            if (fqn.endsWith("_html")) {
                f = new File(outputDir, Hyde.getNameFromFile(fqn));
                Hyde.writeTo(f, Hyde.renderTemplate(fqn, "_html"));
            }
            if (!fqn.endsWith("_md")) continue;
            f = new File(outputDir, Hyde.getNameFromFile(fqn));
            Hyde.writeTo(f, Hyde.mdToHtml(Hyde.renderTemplate(fqn, "_md")));
        }
        Hyde.log("Generating External Docs...");
        Hyde.renderExternalMarkdownTo(wwwDir, "manifold-templates.html", "manifold-deps-parent/manifold-templates/README.md");
        Hyde.renderExternalMarkdownTo(wwwDir, "manifold-js.html", "manifold-deps-parent/manifold-js/README.md");
        Hyde.log("Copying Resources...");
        Hyde.copyDirInto(wwwDir, outputDir, file -> !file.getName().endsWith(".mtf") && !file.getName().endsWith(".less"));
        Hyde.log("Generating CSS from LESS...");
        Hyde.generateCSS(Hyde.fileFromResourcePath("/www/css/site.less"), new File(outputDir, "css/site.css"));
        Hyde.log("Done!");
    }

    private static void renderExternalMarkdownTo(File wwwDir, String targetFileName, String inputFile) throws IOException {
        File output = new File(wwwDir, targetFileName);
        ILayout layout = main.asLayout();
        StringBuffer content = new StringBuffer();
        layout.header((Appendable)content);
        content.append(Hyde.mdToHtml(new String(Files.readAllBytes(new File(inputFile).toPath()))));
        layout.footer((Appendable)content);
        Files.write(output.toPath(), content.toString().getBytes(), new OpenOption[0]);
    }

    private static void generateCSS(File lessFile, File outputFile) throws Exception {
        new LessCompiler().compile(lessFile, outputFile);
    }

    private static void log(String s) {
        System.out.println("Mr. Hyde says: " + s);
    }

    private static File fileFromResourcePath(String name) throws URISyntaxException {
        return new File(Hyde.class.getResource(name).toURI());
    }

    private static void copyDirInto(File in, File out, Predicate<File> filter) {
        for (File file : in.listFiles()) {
            StreamUtil.copy((File)file, (File)out, filter);
        }
    }

    private static String mdToHtml(String markdown) {
        Node doc = MD_PARSER.parse(markdown);
        return MD_RENDERER.render(doc);
    }

    private static void writeTo(File f, String html) throws IOException {
        Files.write(Paths.get(f.getPath(), new String[0]), html.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static String renderTemplate(String fqn, String ext) throws Exception {
        CharSequence className = fqn.subSequence(0, fqn.length() - ext.length());
        Class<?> aClass = Class.forName(className.toString());
        return (String)aClass.getMethod("render", new Class[0]).invoke(null, new Object[0]);
    }

    private static String getNameFromFile(String fqn) {
        int endIndex = fqn.lastIndexOf("_");
        String stripPackage = fqn.substring(4, endIndex);
        String noDots = stripPackage.replace(".", "\u0000");
        return noDots + ".html";
    }

    private static File makeOutputDir() {
        File site = new File("manifold-deps-parent/manifold-docs/www");
        site.mkdirs();
        return site;
    }

    static {
        Bootstrap.init();
        MD_PARSER = Parser.builder().build();
        MD_RENDERER = HtmlRenderer.builder().escapeHtml(false).build();
    }

    public static class BaseTemplate
    extends manifold.templates.runtime.BaseTemplate {
        public String anchor(String content) {
            return "<a class=\"toc_anchor\" name=\"" + this.anchorId(content) + "\">&nbsp;</a>" + content;
        }

        public String linkTo(String name) {
            return "<a href=\"#" + this.anchorId(name) + "\">" + name + "</a>";
        }

        private String anchorId(String content) {
            String strValue = content.replaceAll("[^A-Za-z0-9 ]", "").trim().toLowerCase();
            return strValue.replace(" ", "_");
        }

        static {
            Bootstrap.init();
        }
    }
}

