/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import manifold.ext.ExtensionMethod;
import manifold.ext.StructuralTypeProxyGenerator;
import manifold.ext.api.AbstractDynamicTypeProxy;
import manifold.internal.runtime.Bootstrap;
import manifold.internal.runtime.protocols.ManClassesUrlConnection;

public class DynamicTypeProxyGenerator {
    private DynamicTypeProxyGenerator() {
    }

    public static Class makeProxy(Class<?> iface, Class<?> rootClass, String name) {
        DynamicTypeProxyGenerator gen = new DynamicTypeProxyGenerator();
        String fqnProxy = DynamicTypeProxyGenerator.getNamespace(iface) + '.' + name;
        ManClassesUrlConnection.putProxySupplier((String)fqnProxy, () -> gen.generateProxy(iface, rootClass, name).toString());
        try {
            return Class.forName(fqnProxy, false, iface.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(fqnProxy, false, DynamicTypeProxyGenerator.class.getClassLoader());
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private StringBuilder generateProxy(Class ifaceType, Class implType, String name) {
        return new StringBuilder().append("package ").append(DynamicTypeProxyGenerator.getNamespace(ifaceType)).append(";\n").append("\n").append("public class ").append(name).append(" extends ").append(AbstractDynamicTypeProxy.class.getName()).append(' ').append(" implements ").append(ifaceType.getCanonicalName()).append(" {\n").append("  private final ").append(implType.getCanonicalName()).append(" _root;\n").append("  \n").append("  public ").append(name).append("(").append(implType.getCanonicalName()).append(" root) {\n").append("    super(root);\n").append("    _root = root;\n").append("  }\n").append("  \n").append(this.implementIface(ifaceType)).append("}");
    }

    private static String getNamespace(Class ifaceType) {
        String nspace = ifaceType.getPackage().getName();
        if (nspace.startsWith("java.") || nspace.startsWith("javax.")) {
            nspace = "not" + nspace;
        }
        return nspace;
    }

    private String implementIface(Class ifaceType) {
        StringBuilder sb = new StringBuilder();
        for (Method mi : ifaceType.getMethods()) {
            this.genInterfaceMethodDecl(sb, mi, ifaceType);
        }
        return sb.toString();
    }

    private void genInterfaceMethodDecl(StringBuilder sb, Method mi, Class ifaceType) {
        int i;
        if (mi.isDefault() || Modifier.isStatic(mi.getModifiers())) {
            return;
        }
        if (mi.getAnnotation(ExtensionMethod.class) != null) {
            return;
        }
        if (StructuralTypeProxyGenerator.isObjectMethod(mi)) {
            return;
        }
        Class<?> returnType = mi.getReturnType();
        sb.append("  public ").append(returnType.getCanonicalName()).append(' ').append(mi.getName()).append("(");
        Class<?>[] params = mi.getParameterTypes();
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            Class<?> pi = params[i2];
            sb.append(pi.getCanonicalName()).append(" p").append(i2);
        }
        sb.append(") {\n").append(returnType == Void.TYPE ? "    " : "    return ").append(this.maybeCastReturnType(returnType)).append("_root").append(".call(").append(ifaceType.getCanonicalName()).append(".class, \"").append(mi.getName()).append("\", ").append(mi.getReturnType().getCanonicalName()).append(".class, ").append("new Class[] {");
        Class<?>[] parameterTypes = mi.getParameterTypes();
        for (i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Class<?> paramType = parameterTypes[i];
            sb.append(paramType.getCanonicalName()).append(".class");
        }
        sb.append("}, ");
        sb.append("new Object[] {");
        for (i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(" p").append(i);
        }
        sb.append("});\n");
        sb.append("  }\n");
    }

    private String maybeCastReturnType(Class returnType) {
        return returnType != Void.TYPE ? "(" + returnType.getCanonicalName() + ")" : "";
    }

    static {
        Bootstrap.init();
    }
}

