/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IModuleComponent;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.api.type.ITypeProcessor;
import manifold.api.type.JavaTypeManifold;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.ext.ExtCodeGen;
import manifold.ext.ExtensionTransformer;
import manifold.ext.Model;
import manifold.ext.api.Extension;
import manifold.internal.host.ManifoldHost;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.TypeProcessor;
import manifold.internal.runtime.Bootstrap;
import manifold.util.StreamUtil;

public class ExtensionManifold
extends JavaTypeManifold<Model>
implements ITypeProcessor {
    public static final String EXTENSIONS_PACKAGE = "extensions";
    private static final Set<String> FILE_EXTENSIONS;

    public void init(IModuleComponent typeLoader) {
        this.init(typeLoader, (fqn, files) -> new Model((String)fqn, (Set<IFile>)files, this));
    }

    public boolean handlesFileExtension(String fileExtension) {
        return FILE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    public ContributorKind getContributorKind() {
        return ContributorKind.Supplemental;
    }

    protected String aliasFqn(String fqn, IFile file) {
        String extendedType;
        int iDot;
        int iExt;
        if (fqn.length() > EXTENSIONS_PACKAGE.length() + 2 && (iExt = fqn.indexOf("extensions.")) >= 0 && (iDot = (extendedType = fqn.substring(iExt + EXTENSIONS_PACKAGE.length() + 1)).lastIndexOf(46)) > 0) {
            return extendedType.substring(0, iDot);
        }
        return null;
    }

    public boolean handlesFile(IFile file) {
        Set fqns = this.getModule().getPathCache().getFqnForFile(file);
        if (fqns == null) {
            return false;
        }
        for (String fqn : fqns) {
            String extendedType;
            int iDot;
            int iExt;
            if (fqn.length() <= EXTENSIONS_PACKAGE.length() + 2 || (iExt = fqn.indexOf("extensions.")) < 0 || (iDot = (extendedType = fqn.substring(iExt + EXTENSIONS_PACKAGE.length() + 1)).lastIndexOf(46)) <= 0) continue;
            try {
                if (file.getExtension().equalsIgnoreCase("java")) {
                    String content = StreamUtil.getContent((Reader)new InputStreamReader(file.openInputStream()));
                    return content.contains("@Extension") && content.contains(Extension.class.getPackage().getName());
                }
                String content = StreamUtil.getContent((Reader)new InputStreamReader(file.openInputStream()));
                return content.contains(Extension.class.getName().replace('.', '/'));
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        if (!this.isType(topLevel)) {
            return false;
        }
        return this.delegateToPrimaryManifold(topLevel, relativeInner) || this.delegateToJavaClass(topLevel, relativeInner);
    }

    private boolean delegateToJavaClass(String topLevel, String relativeInner) {
        try {
            Class<?> cls = Class.forName(topLevel, false, ManifoldHost.instance().getActualClassLoader());
            for (Class<?> inner : cls.getDeclaredClasses()) {
                if (!this.isInnerClass(inner, relativeInner)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean delegateToPrimaryManifold(String topLevel, String relativeInner) {
        Set tms = this.getModule().findTypeManifoldsFor(topLevel);
        if (tms != null) {
            for (ITypeManifold tm : tms) {
                if (tm.getContributorKind() != ContributorKind.Primary || !(tm instanceof ResourceFileTypeManifold)) continue;
                return ((ResourceFileTypeManifold)tm).isInnerType(topLevel, relativeInner);
            }
        }
        return false;
    }

    private boolean isInnerClass(Class<?> cls, String relativeInner) {
        String remainder;
        String name;
        int iDot = relativeInner.indexOf(46);
        if (iDot > 0) {
            name = relativeInner.substring(0, iDot);
            remainder = relativeInner.substring(iDot + 1);
        } else {
            name = relativeInner;
            remainder = null;
        }
        if (cls.getSimpleName().equals(name)) {
            if (remainder != null) {
                for (Class<?> m : cls.getDeclaredClasses()) {
                    if (!this.isInnerClass(m, remainder)) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public void clear() {
        super.clear();
    }

    protected String contribute(String topLevelFqn, String existing, Model model, DiagnosticListener<JavaFileObject> errorHandler) {
        return new ExtCodeGen(model, topLevelFqn, existing).make(errorHandler);
    }

    public void process(TypeElement typeElement, TypeProcessor typeProcessor, IssueReporter<JavaFileObject> issueReporter) {
        if (typeElement.getKind() == ElementKind.CLASS || typeElement.getKind() == ElementKind.INTERFACE) {
            ExtensionTransformer visitor = new ExtensionTransformer(this, typeProcessor);
            typeProcessor.getTree().accept(visitor);
        }
    }

    static {
        Bootstrap.init();
        FILE_EXTENSIONS = new HashSet<String>(Arrays.asList("java", "class"));
    }
}

