/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.type.NoType;
import javax.tools.Diagnostic;
import manifold.ExtIssueMsg;
import manifold.api.host.IModule;
import manifold.api.type.ITypeManifold;
import manifold.api.type.Precompile;
import manifold.ext.DynamicTypeProxyGenerator;
import manifold.ext.ExtensionManifold;
import manifold.ext.ExtensionMethod;
import manifold.ext.StructuralTypeEraser;
import manifold.ext.StructuralTypeProxyGenerator;
import manifold.ext.TypeUtil;
import manifold.ext.api.Extension;
import manifold.ext.api.ICallHandler;
import manifold.ext.api.Structural;
import manifold.ext.api.This;
import manifold.internal.host.ManifoldHost;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavaParser;
import manifold.internal.javac.TypeProcessor;
import manifold.internal.runtime.Bootstrap;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.ConcurrentHashSet;
import manifold.util.concurrent.ConcurrentWeakHashMap;

public class ExtensionTransformer
extends TreeTranslator {
    private static final String STRUCTURAL_PROXY = "_structuralproxy_";
    private static Map<Class, Map<Class, Constructor>> PROXY_CACHE;
    private static final Map<Object, Set<Class>> ID_MAP;
    private final ExtensionManifold _sp;
    private final TypeProcessor _tp;
    private boolean _bridgeMethod;

    ExtensionTransformer(ExtensionManifold sp, TypeProcessor typeProcessor) {
        this._sp = sp;
        this._tp = typeProcessor;
    }

    public TypeProcessor getTypeProcessor() {
        return this._tp;
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        super.visitIdent(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (tree.sym != null && TypeUtil.isStructuralInterface(this._tp, tree.sym) && !this.isReceiver(tree)) {
            Symbol.ClassSymbol objectSym = this.getObjectClass();
            Tree parent = this._tp.getParent((Tree)tree);
            JCTree.JCIdent objIdent = this._tp.getTreeMaker().Ident(objectSym);
            if (parent instanceof JCTree.JCVariableDecl) {
                ((JCTree.JCVariableDecl)parent).type = objectSym.type;
                long parameterModifier = 0x200000000L;
                if ((((JCTree.JCVariableDecl)parent).mods.flags & parameterModifier) != 0L) {
                    objIdent.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).sym.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).vartype = objIdent;
                }
            } else if (parent instanceof JCTree.JCWildcard) {
                JCTree.JCWildcard wildcard = (JCTree.JCWildcard)parent;
                wildcard.type = new Type.WildcardType(objectSym.type, wildcard.kind.kind, wildcard.type.tsym);
            }
            tree = objIdent;
            tree.type = objectSym.type;
        }
        this.result = tree;
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        super.visitLambda(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        tree.type = this.eraseStructureType(tree.type);
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type target : tree.targets) {
            types.add(this.eraseStructureType(target));
        }
        tree.targets = List.from(types);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        super.visitSelect(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (TypeUtil.isStructuralInterface(this._tp, tree.sym) && !this.isReceiver(tree)) {
            Symbol.ClassSymbol objectSym = this.getObjectClass();
            JCTree.JCIdent objIdent = this._tp.getTreeMaker().Ident(objectSym);
            Tree parent = this._tp.getParent((Tree)tree);
            if (parent instanceof JCTree.JCVariableDecl) {
                ((JCTree.JCVariableDecl)parent).type = objectSym.type;
                long parameterModifier = 0x200000000L;
                if ((((JCTree.JCVariableDecl)parent).mods.flags & parameterModifier) != 0L) {
                    objIdent.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).sym.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).vartype = objIdent;
                }
            } else if (parent instanceof JCTree.JCWildcard) {
                JCTree.JCWildcard wildcard = (JCTree.JCWildcard)parent;
                wildcard.type = new Type.WildcardType(objectSym.type, wildcard.kind.kind, wildcard.type.tsym);
            }
            this.result = objIdent;
        } else {
            this.result = tree;
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        super.visitTypeCast(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            this.eraseCompilerGeneratedCast(tree);
            return;
        }
        if (TypeUtil.isStructuralInterface(this._tp, tree.type.tsym)) {
            tree.expr = this.replaceCastExpression(tree.getExpression(), tree.type);
            tree.type = this.getObjectClass().type;
        }
        this.result = tree;
    }

    private void eraseCompilerGeneratedCast(JCTree.JCTypeCast tree) {
        if (TypeUtil.isStructuralInterface(this._tp, tree.type.tsym) && !this.isConstructProxyCall(tree.getExpression())) {
            tree.type = this.getObjectClass().type;
            TreeMaker make = this._tp.getTreeMaker();
            tree.clazz = make.Type(this.getObjectClass().type);
        }
    }

    private boolean isConstructProxyCall(JCTree.JCExpression expression) {
        if (expression instanceof JCTree.JCMethodInvocation) {
            JCTree.JCExpression meth = ((JCTree.JCMethodInvocation)expression).meth;
            return meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)meth).getIdentifier().toString().equals("constructProxy");
        }
        return expression instanceof JCTree.JCTypeCast && this.isConstructProxyCall(((JCTree.JCTypeCast)expression).getExpression());
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        super.visitApply(tree);
        Symbol.MethodSymbol method = this.findExtMethod(tree);
        this.eraseGenericStructuralVarargs(tree);
        if (this._tp.isGenerate()) {
            return;
        }
        if (method != null) {
            this.replaceExtCall(tree, method);
            this.result = tree;
        } else {
            this.result = this.isStructuralMethod(tree) ? this.replaceStructuralCall(tree) : tree;
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        super.visitClassDef(tree);
        this.verifyExtensionInterfaces(tree);
        this.precompileClasses(tree);
    }

    private void precompileClasses(JCTree.JCClassDecl tree) {
        HashMap<String, Set<String>> typeNames = new HashMap<String, Set<String>>();
        for (JCTree.JCAnnotation anno : tree.getModifiers().getAnnotations()) {
            if (!anno.getAnnotationType().type.toString().equals(Precompile.class.getCanonicalName())) continue;
            this.getTypesToCompile(anno, typeNames);
        }
        this.precompile(typeNames);
    }

    private void getTypesToCompile(JCTree.JCAnnotation precompileAnno, Map<String, Set<String>> typeNames) {
        Attribute.Compound attribute = precompileAnno.attribute;
        if (attribute == null) {
            return;
        }
        String typeManifoldClassName = null;
        String regex = ".*";
        for (Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            if (((Name)argName).toString().equals("typeManifold")) {
                typeManifoldClassName = ((Attribute)pair.snd).getValue().toString();
                continue;
            }
            if (!((Name)argName).toString().equals("typeNames")) continue;
            regex = ((Attribute)pair.snd).getValue().toString();
        }
        Set regexes = typeNames.computeIfAbsent(typeManifoldClassName, tm -> new HashSet());
        regexes.add(regex);
    }

    private void precompile(Map<String, Set<String>> typeNames) {
        for (ITypeManifold tm : ManifoldHost.instance().getCurrentModule().getTypeManifolds()) {
            for (Map.Entry<String, Set<String>> entry : typeNames.entrySet()) {
                String typeManifoldClassName = entry.getKey();
                if (!tm.getClass().getName().equals(typeManifoldClassName)) continue;
                Collection<String> namesToPrecompile = this.computeNamesToPrecompile(tm.getAllTypeNames(), entry.getValue());
                for (String fqn : namesToPrecompile) {
                    JavacElements elementUtils = JavacElements.instance(this._tp.getContext());
                    elementUtils.getTypeElement(fqn);
                }
            }
        }
    }

    private Collection<String> computeNamesToPrecompile(Collection<String> allTypeNames, Set<String> regexes) {
        HashSet<String> matchingTypes = new HashSet<String>();
        for (String fqn : allTypeNames) {
            if (!regexes.stream().anyMatch(fqn::matches)) continue;
            matchingTypes.add(fqn);
        }
        return matchingTypes;
    }

    private void verifyExtensionInterfaces(JCTree.JCClassDecl tree) {
        if (!this.hasAnnotation((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations(), Extension.class)) {
            return;
        }
        block0: for (JCTree.JCExpression iface : tree.getImplementsClause()) {
            Symbol.TypeSymbol ifaceSym = iface.type.tsym;
            if (ifaceSym == this._tp.getSymtab().objectType.tsym) continue;
            for (Attribute.Compound anno : ifaceSym.getAnnotationMirrors()) {
                if (!anno.type.toString().equals(Structural.class.getName())) continue;
                continue block0;
            }
            this._tp.report((JCTree)iface, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_ONLY_STRUCTURAL_INTERFACE_ALLOWED_HERE.get(new Object[]{iface.toString()}));
        }
    }

    private boolean shouldProcessForGeneration() {
        return this._bridgeMethod;
    }

    private boolean isBridgeMethod(JCTree.JCMethodDecl tree) {
        long modifiers = tree.getModifiers().flags;
        return (0x80000000L & modifiers) != 0L;
    }

    private Type eraseStructureType(Type type) {
        return (Type)new StructuralTypeEraser(this).visit(type);
    }

    private boolean isReceiver(JCTree tree) {
        Tree parent = this._tp.getParent((Tree)tree);
        if (parent instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)parent).getExpression() == tree;
        }
        return false;
    }

    Symbol.ClassSymbol getObjectClass() {
        Symtab symbols = Symtab.instance(this._tp.getContext());
        return (Symbol.ClassSymbol)symbols.objectType.tsym;
    }

    private void eraseGenericStructuralVarargs(JCTree.JCMethodInvocation tree) {
        if (tree.varargsElement instanceof Type.ClassType && TypeUtil.isStructuralInterface(this._tp, tree.varargsElement.tsym)) {
            tree.varargsElement = this._tp.getSymtab().objectType;
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if (this.isBridgeMethod(tree)) {
            this._bridgeMethod = true;
        }
        try {
            super.visitMethodDef(tree);
        }
        finally {
            this._bridgeMethod = false;
        }
        if (this._tp.isGenerate()) {
            return;
        }
        if (tree.sym.owner.isAnonymous()) {
            JCTree.JCClassDecl anonymousClassDef = (JCTree.JCClassDecl)this._tp.getTreeUtil().getTree(tree.sym.owner);
            this._tp.preserveInnerClassForGenerationPhase(anonymousClassDef);
        }
        this.verifyExtensionMethod(tree);
        this.result = tree;
    }

    private void verifyExtensionMethod(JCTree.JCMethodDecl tree) {
        if (!this.isFromExtensionClass(tree)) {
            return;
        }
        String extendedClassName = this._tp.getCompilationUnit().getPackageName().toString();
        int iExt = extendedClassName.indexOf("extensions.");
        if (iExt < 0) {
            return;
        }
        extendedClassName = extendedClassName.substring(iExt + "extensions".length() + 1);
        boolean thisAnnoFound = false;
        java.util.List parameters = tree.getParameters();
        for (int i = 0; i < ((List)parameters).size(); ++i) {
            JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)((List)parameters).get(i);
            long methodModifiers = tree.getModifiers().flags;
            if (this.hasAnnotation((List<JCTree.JCAnnotation>)param.getModifiers().getAnnotations(), This.class)) {
                Symbol.ClassSymbol extendClassSym;
                thisAnnoFound = true;
                if (i != 0) {
                    this._tp.report((JCTree)param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_THIS_FIRST.get(new Object[0]));
                }
                if (param.type.tsym instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)param.type.tsym).className().equals(extendedClassName) || (extendClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), extendedClassName)) == null || TypeUtil.isStructuralInterface(this._tp, extendClassSym)) continue;
                this._tp.report((JCTree)param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_EXPECTING_TYPE_FOR_THIS.get(new Object[]{extendedClassName}));
                continue;
            }
            if (i != 0 || !Modifier.isStatic((int)methodModifiers) || !Modifier.isPublic((int)methodModifiers) || !param.type.toString().equals(extendedClassName)) continue;
            this._tp.report((JCTree)param, Diagnostic.Kind.WARNING, ExtIssueMsg.MSG_MAYBE_MISSING_THIS.get(new Object[0]));
        }
        if (thisAnnoFound || this.hasAnnotation((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations(), Extension.class)) {
            long methodModifiers = tree.getModifiers().flags;
            if (!Modifier.isStatic((int)methodModifiers)) {
                this._tp.report((JCTree)tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_MUST_BE_STATIC.get(new Object[]{tree.getName()}));
            }
            if (Modifier.isPrivate((int)methodModifiers)) {
                this._tp.report((JCTree)tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_MUST_NOT_BE_PRIVATE.get(new Object[]{tree.getName()}));
            }
        }
    }

    private boolean isFromExtensionClass(JCTree.JCMethodDecl tree) {
        Tree parent = this._tp.getParent((Tree)tree);
        return parent instanceof JCTree.JCClassDecl && this.hasAnnotation((List<JCTree.JCAnnotation>)((JCTree.JCClassDecl)parent).getModifiers().getAnnotations(), Extension.class);
    }

    private boolean hasAnnotation(List<JCTree.JCAnnotation> annotations, Class<? extends Annotation> annoClass) {
        for (JCTree.JCAnnotation anno : annotations) {
            if (!anno.getAnnotationType().type.toString().equals(annoClass.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private JCTree replaceStructuralCall(JCTree.JCMethodInvocation theCall) {
        JCTree.JCExpression methodSelect = theCall.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            Symtab symbols = this._tp.getSymtab();
            Names names = Names.instance(this._tp.getContext());
            Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), this.getClass().getName());
            Symbol.MethodSymbol makeInterfaceProxyMethod = this.resolveMethod(theCall.pos(), names.fromString("constructProxy"), reflectMethodClassSym.type, List.from(new Type[]{symbols.objectType, symbols.classType}));
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            JCTree.JCExpression thisArg = m.selected;
            ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
            newArgs.add(thisArg);
            JCTree.JCFieldAccess ifaceClassExpr = (JCTree.JCFieldAccess)this.memberAccess(make, javacElems, thisArg.type.tsym.getQualifiedName().toString() + ".class");
            ifaceClassExpr.type = symbols.classType;
            ifaceClassExpr.sym = symbols.classType.tsym;
            this.assignTypes(ifaceClassExpr.selected, thisArg.type.tsym);
            newArgs.add(ifaceClassExpr);
            JCTree.JCMethodInvocation makeProxyCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, ExtensionTransformer.class.getName() + ".constructProxy"), List.from(newArgs));
            makeProxyCall.setPos(theCall.pos);
            makeProxyCall.type = thisArg.type;
            JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)makeProxyCall.getMethodSelect();
            newMethodSelect.sym = makeInterfaceProxyMethod;
            newMethodSelect.type = makeInterfaceProxyMethod.type;
            this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
            JCTree.JCTypeCast cast = make.TypeCast(thisArg.type, (JCTree.JCExpression)makeProxyCall);
            cast.type = thisArg.type;
            ((JCTree.JCFieldAccess)theCall.meth).selected = cast;
            return theCall;
        }
        return null;
    }

    private JCTree.JCExpression replaceCastExpression(JCTree.JCExpression expression, Type type) {
        TreeMaker make = this._tp.getTreeMaker();
        Symtab symbols = this._tp.getSymtab();
        Names names = Names.instance(this._tp.getContext());
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), this.getClass().getName());
        Symbol.MethodSymbol makeInterfaceProxyMethod = this.resolveMethod(expression.pos(), names.fromString("assignStructuralIdentity"), reflectMethodClassSym.type, List.from(new Type[]{symbols.objectType, symbols.classType}));
        JavacElements javacElems = this._tp.getElementUtil();
        ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
        newArgs.add(expression);
        JCTree.JCFieldAccess ifaceClassExpr = (JCTree.JCFieldAccess)this.memberAccess(make, javacElems, type.tsym.getQualifiedName().toString() + ".class");
        ifaceClassExpr.type = symbols.classType;
        ifaceClassExpr.sym = symbols.classType.tsym;
        this.assignTypes(ifaceClassExpr.selected, type.tsym);
        newArgs.add(ifaceClassExpr);
        JCTree.JCMethodInvocation makeProxyCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, ExtensionTransformer.class.getName() + ".assignStructuralIdentity"), List.from(newArgs));
        makeProxyCall.type = symbols.objectType;
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)makeProxyCall.getMethodSelect();
        newMethodSelect.sym = makeInterfaceProxyMethod;
        newMethodSelect.type = makeInterfaceProxyMethod.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        JCTree.JCTypeCast castCall = make.TypeCast(symbols.objectType, (JCTree.JCExpression)makeProxyCall);
        castCall.type = symbols.objectType;
        return castCall;
    }

    private void replaceExtCall(JCTree.JCMethodInvocation tree, Symbol.MethodSymbol method) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            boolean isStatic = m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            JCTree.JCExpression thisArg = m.selected;
            String extensionFqn = ((Symbol)method.getEnclosingElement()).asType().tsym.toString();
            m.selected = this.memberAccess(make, javacElems, extensionFqn);
            BasicJavacTask javacTask = ClassSymbols.instance((IModule)this._sp.getTypeLoader().getModule()).getJavacTask();
            Symbol.ClassSymbol extensionClassSym = (Symbol.ClassSymbol)ClassSymbols.instance((IModule)this._sp.getTypeLoader().getModule()).getClassSymbol(javacTask, extensionFqn).getFirst();
            this.assignTypes(m.selected, extensionClassSym);
            m.sym = method;
            m.type = method.type;
            if (!isStatic) {
                ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>(tree.args);
                newArgs.add(0, thisArg);
                tree.args = List.from(newArgs);
            }
        }
    }

    private void assignTypes(JCTree.JCExpression m, Symbol symbol) {
        if (m instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)m;
            fieldAccess.sym = symbol;
            fieldAccess.type = symbol.type;
            this.assignTypes(fieldAccess.selected, symbol.owner);
        } else if (m instanceof JCTree.JCIdent) {
            JCTree.JCIdent fieldAccess = (JCTree.JCIdent)m;
            fieldAccess.sym = symbol;
            fieldAccess.type = symbol.type;
        }
    }

    private Symbol.MethodSymbol findExtMethod(JCTree.JCMethodInvocation tree) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof MemberSelectTree) {
            JCTree.JCFieldAccess meth = (JCTree.JCFieldAccess)tree.meth;
            if (meth.sym == null || !meth.sym.hasAnnotations()) {
                return null;
            }
            for (Attribute.Compound annotation : meth.sym.getAnnotationMirrors()) {
                if (!annotation.type.toString().equals(ExtensionMethod.class.getName())) continue;
                String extensionClass = (String)((Attribute)annotation.values.get((int)0).snd).getValue();
                boolean isStatic = (Boolean)((Attribute)annotation.values.get((int)1).snd).getValue();
                BasicJavacTask javacTask = (BasicJavacTask)this._tp.getJavacTask();
                Symbol.ClassSymbol extClassSym = (Symbol.ClassSymbol)ClassSymbols.instance((IModule)this._sp.getTypeLoader().getModule()).getClassSymbol(javacTask, extensionClass).getFirst();
                if (extClassSym == null) {
                    return null;
                }
                Types types = Types.instance(javacTask.getContext());
                block1: for (Symbol elem : IDynamicJdk.instance().getMembers(extClassSym)) {
                    int thisOffset;
                    if (!(elem instanceof Symbol.MethodSymbol) || !elem.flatName().toString().equals(meth.sym.name.toString())) continue;
                    Symbol.MethodSymbol extMethodSym = (Symbol.MethodSymbol)elem;
                    java.util.List extParams = extMethodSym.getParameters();
                    java.util.List calledParams = ((Symbol.MethodSymbol)meth.sym).getParameters();
                    int n = thisOffset = isStatic ? 0 : 1;
                    if (((List)extParams).size() - thisOffset != ((List)calledParams).size()) continue;
                    for (int i = thisOffset; i < ((List)extParams).size(); ++i) {
                        Symbol.VarSymbol extParam = (Symbol.VarSymbol)((List)extParams).get(i);
                        Symbol.VarSymbol calledParam = (Symbol.VarSymbol)((List)calledParams).get(i - thisOffset);
                        if (!types.isSameType(types.erasure(extParam.type), types.erasure(calledParam.type))) continue block1;
                    }
                    return extMethodSym;
                }
            }
        }
        return null;
    }

    private boolean isStructuralMethod(JCTree.JCMethodInvocation tree) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            if (m.sym != null && !m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC)) {
                JCTree.JCExpression thisArg = m.selected;
                if (TypeUtil.isStructuralInterface(this._tp, thisArg.type.tsym)) {
                    return true;
                }
            }
        }
        return false;
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements javacElems, String path) {
        return this.memberAccess(make, javacElems, path.split("\\."));
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements node, String ... components) {
        JCTree.JCExpression expr = make.Ident(node.getName(components[0]));
        for (int i = 1; i < components.length; ++i) {
            expr = make.Select(expr, node.getName(components[i]));
        }
        return expr;
    }

    public static Object constructProxy(Object root, Class iface) {
        return ExtensionTransformer.createNewProxy(root, iface);
    }

    public static Object assignStructuralIdentity(Object obj, Class iface) {
        if (obj != null) {
            Set ifaces = ID_MAP.computeIfAbsent(obj, k -> new ConcurrentHashSet());
            ifaces.add(iface);
        }
        return obj;
    }

    private static Object createNewProxy(Object root, Class<?> iface) {
        Constructor<?> proxyClassCtor;
        if (root == null) {
            return null;
        }
        Class<?> rootClass = root.getClass();
        if (iface.isAssignableFrom(rootClass)) {
            return root;
        }
        Map<Class, Constructor> proxyByClass = PROXY_CACHE.get(iface);
        if (proxyByClass == null) {
            proxyByClass = new ConcurrentHashMap<Class, Constructor>();
            PROXY_CACHE.put(iface, proxyByClass);
        }
        if ((proxyClassCtor = proxyByClass.get(rootClass)) == null) {
            Class proxyClass = ExtensionTransformer.createProxy(iface, rootClass);
            proxyClassCtor = proxyClass.getConstructors()[0];
            proxyByClass.put(rootClass, proxyClassCtor);
        }
        try {
            ReflectUtil.setAccessible((Constructor)proxyClassCtor);
            return proxyClassCtor.newInstance(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class createProxy(Class iface, Class rootClass) {
        String relativeProxyName = rootClass.getCanonicalName().replace('.', '_') + STRUCTURAL_PROXY + iface.getCanonicalName().replace('.', '_');
        if (ExtensionTransformer.hasCallHandlerMethod(rootClass)) {
            return DynamicTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName);
        }
        return StructuralTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName);
    }

    private static boolean hasCallHandlerMethod(Class rootClass) {
        String fqn = rootClass.getCanonicalName();
        BasicJavacTask javacTask = JavaParser.instance().getJavacTask();
        manifold.util.Pair classSymbol = ClassSymbols.instance((IModule)ManifoldHost.getGlobalModule()).getClassSymbol(javacTask, fqn);
        manifold.util.Pair callHandlerSymbol = ClassSymbols.instance((IModule)ManifoldHost.getGlobalModule()).getClassSymbol(javacTask, ICallHandler.class.getCanonicalName());
        if (Types.instance(javacTask.getContext()).isAssignable((Type)((Symbol.ClassSymbol)classSymbol.getFirst()).asType(), (Type)((Symbol.ClassSymbol)callHandlerSymbol.getFirst()).asType())) {
            return true;
        }
        return ExtensionTransformer.hasCallMethod(javacTask, (Symbol.ClassSymbol)classSymbol.getFirst());
    }

    private static boolean hasCallMethod(BasicJavacTask javacTask, Symbol.ClassSymbol classSymbol) {
        Name call = Names.instance(javacTask.getContext()).fromString("call");
        Iterable elems = IDynamicJdk.instance().getMembersByName(classSymbol, call);
        for (Symbol s : elems) {
            if (!(s instanceof Symbol.MethodSymbol)) continue;
            java.util.List parameters = ((Symbol.MethodSymbol)s).getParameters();
            if (((List)parameters).size() != 6) {
                return false;
            }
            Symtab symbols = Symtab.instance(javacTask.getContext());
            Types types = Types.instance(javacTask.getContext());
            return types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(0)).asType()).equals(types.erasure(symbols.classType)) && ((Type)((Symbol.VarSymbol)((List)parameters).get(1)).asType()).equals(symbols.stringType) && ((Type)((Symbol.VarSymbol)((List)parameters).get(2)).asType()).equals(symbols.stringType) && types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(3)).asType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(4)).asType() instanceof Type.ArrayType && types.erasure(((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(4)).asType()).getComponentType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(5)).asType() instanceof Type.ArrayType && ((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(5)).asType()).getComponentType().equals(symbols.objectType);
        }
        Type superclass = classSymbol.getSuperclass();
        if (!(superclass instanceof NoType) && ExtensionTransformer.hasCallMethod(javacTask, (Symbol.ClassSymbol)superclass.tsym)) {
            return true;
        }
        for (Type iface : classSymbol.getInterfaces()) {
            if (!ExtensionTransformer.hasCallMethod(javacTask, (Symbol.ClassSymbol)iface.tsym)) continue;
            return true;
        }
        return false;
    }

    private Symbol.MethodSymbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Name name, Type qual, List<Type> args) {
        return ExtensionTransformer.resolveMethod(pos, this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), name, qual, args);
    }

    private static Symbol.MethodSymbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Context ctx, JCTree.JCCompilationUnit compUnit, Name name, Type qual, List<Type> args) {
        Resolve rs = Resolve.instance(ctx);
        AttrContext attrContext = new AttrContext();
        AttrContextEnv env = new AttrContextEnv(pos.getTree(), attrContext);
        env.toplevel = compUnit;
        return rs.resolveInternalMethod(pos, env, qual, name, args, null);
    }

    public static Object invokeUnhandled(Object thiz, Class proxiedIface, String name, Class returnType, Class[] paramTypes, Object[] args) {
        Set<Class> ifaces = ID_MAP.get(thiz);
        if (ifaces != null) {
            for (Class iface : ifaces) {
                Method m;
                if (iface == proxiedIface || (m = ExtensionTransformer.findMethod(iface, name, paramTypes)) == null) continue;
                try {
                    Object result = m.invoke(ExtensionTransformer.constructProxy(thiz, iface), args);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ICallHandler.UNHANDLED;
    }

    private static Method findMethod(Class<?> iface, String name, Class[] paramTypes) {
        try {
            Method m = iface.getDeclaredMethod(name, paramTypes);
            if (m == null) {
                Class<?> superIface;
                Class<?>[] classArray = iface.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (m = ExtensionTransformer.findMethod(superIface = classArray[i], name, paramTypes)) == null; ++i) {
                }
            }
            if (m != null) {
                return m;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    static {
        Bootstrap.init();
        PROXY_CACHE = new ConcurrentHashMap<Class, Map<Class, Constructor>>();
        ID_MAP = new ConcurrentWeakHashMap();
    }
}

