/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import manifold.api.fs.IFile;
import manifold.api.host.IModuleComponent;
import manifold.api.host.RefreshKind;
import manifold.api.host.RefreshRequest;
import manifold.api.type.IModel;
import manifold.api.type.JavaTypeManifold;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.ext.IExtensionClassProducer;
import manifold.internal.runtime.Bootstrap;
import manifold.util.cache.FqnCache;
import manifold.util.concurrent.LocklessLazyVar;

public abstract class AbstractExtensionProducer<M extends IModel>
extends JavaTypeManifold<M>
implements IExtensionClassProducer {
    private final LocklessLazyVar<Map<String, LocklessLazyVar<M>>> _extensionToModel = LocklessLazyVar.make(this::buildCache);
    private final LocklessLazyVar<Map<String, Set<IFile>>> _extensionToFiles = LocklessLazyVar.make(HashMap::new);

    public void init(IModuleComponent moduleComponent) {
        super.init(moduleComponent, this::createModel);
    }

    protected abstract String getFileExt();

    protected abstract M createModel(String var1, Set<IFile> var2);

    protected abstract String makeExtensionClassName(String var1);

    protected abstract String deriveExtendedClassFrom(String var1);

    public String getTypeNameForFile(String defaultFqn, IFile file) {
        return null;
    }

    public String findTopLevelFqn(String fqn) {
        if (((Map)this._extensionToModel.get()).containsKey(fqn)) {
            return fqn;
        }
        return null;
    }

    private Map<String, LocklessLazyVar<M>> buildCache() {
        HashMap<String, LocklessLazyVar<M>> extensionToModel = new HashMap<String, LocklessLazyVar<M>>();
        FqnCache extensionCache = this.getModule().getPathCache().getExtensionCache(this.getFileExt());
        Set files = extensionCache.getFqns();
        for (String fileFqn : files) {
            IFile file = (IFile)extensionCache.get(fileFqn);
            this.addFile(extensionToModel, file);
        }
        return extensionToModel;
    }

    private void addFile(Map<String, LocklessLazyVar<M>> extensionToModel, IFile file) {
        Set<String> extendedTypes = this.getExtendedTypes(file);
        for (String extended : extendedTypes) {
            String extension = this.makeExtensionClassName(extended);
            Set files = ((Map)this._extensionToFiles.get()).computeIfAbsent(extension, e -> new HashSet());
            files.add(file);
            LocklessLazyVar lazyModel = extensionToModel.putIfAbsent(extension, LocklessLazyVar.make(() -> this.createModel(extension, files)));
            if (lazyModel == null) continue;
            ((IModel)Objects.requireNonNull(lazyModel.get())).addFile(file);
        }
    }

    private void removeFile(IFile file) {
        for (String extension : this.getTypesForFile(file)) {
            ((Map)this._extensionToModel.get()).remove(extension);
            ((Set)((Map)this._extensionToFiles.get()).get(extension)).remove(file);
        }
    }

    protected ResourceFileTypeManifold.CacheClearer createCacheClearer() {
        return new MyCacheClearer();
    }

    public RefreshKind refreshedFile(IFile file, String[] types, RefreshKind kind) {
        this._extensionToModel.clear();
        return kind;
    }

    public boolean handlesFileExtension(String fileExtension) {
        return fileExtension.equalsIgnoreCase(this.getFileExt());
    }

    protected Map<String, LocklessLazyVar<M>> getPeripheralTypes() {
        return (Map)this._extensionToModel.get();
    }

    public boolean isInnerType(String topLevelFqn, String relativeInner) {
        return false;
    }

    @Override
    public boolean isExtendedType(String fqn) {
        String extension = this.makeExtensionClassName(fqn);
        return ((Map)this._extensionToModel.get()).containsKey(extension);
    }

    @Override
    public Set<String> getExtensionClasses(String extendedType) {
        return this.isExtendedType(extendedType) ? this.getExtensions(extendedType) : Collections.emptySet();
    }

    private Set<String> getExtensions(String extendedType) {
        String extension = this.makeExtensionClassName(extendedType);
        if (((Map)this._extensionToModel.get()).containsKey(extension)) {
            return Collections.singleton(extension);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getExtendedTypes() {
        return ((Map)this._extensionToModel.get()).keySet().stream().map(this::deriveExtendedClassFrom).collect(Collectors.toSet());
    }

    public String[] getTypesForFile(IFile file) {
        if (!this.handlesFile(file)) {
            return new String[0];
        }
        HashSet<String> types = new HashSet<String>();
        for (Map.Entry entry : ((Map)Objects.requireNonNull(this._extensionToModel.get())).entrySet()) {
            String extension = (String)entry.getKey();
            IModel model = (IModel)Objects.requireNonNull(((LocklessLazyVar)entry.getValue()).get());
            if (!model.getFiles().contains(file)) continue;
            types.add(extension);
        }
        return types.toArray(new String[types.size()]);
    }

    @Override
    public Set<String> getExtendedTypesForFile(IFile file) {
        if (!this.handlesFile(file)) {
            return Collections.emptySet();
        }
        HashSet<String> types = new HashSet<String>();
        for (Map.Entry entry : ((Map)Objects.requireNonNull(this._extensionToModel.get())).entrySet()) {
            String extension = (String)entry.getKey();
            IModel model = (IModel)Objects.requireNonNull(((LocklessLazyVar)entry.getValue()).get());
            if (!model.getFiles().contains(file)) continue;
            types.add(this.deriveExtendedClassFrom(extension));
        }
        return types;
    }

    protected abstract Set<String> getExtendedTypes(IFile var1);

    static {
        Bootstrap.init();
    }

    private class MyCacheClearer
    extends ResourceFileTypeManifold.CacheClearer {
        private MyCacheClearer() {
            super((ResourceFileTypeManifold)AbstractExtensionProducer.this);
        }

        public void preRefresh(RefreshRequest request) {
            switch (request.kind) {
                case CREATION: {
                    AbstractExtensionProducer.this.addFile((Map)AbstractExtensionProducer.this._extensionToModel.get(), request.file);
                    break;
                }
                case MODIFICATION: {
                    AbstractExtensionProducer.this.removeFile(request.file);
                    AbstractExtensionProducer.this.addFile((Map)AbstractExtensionProducer.this._extensionToModel.get(), request.file);
                }
            }
        }

        public void postRefresh(RefreshRequest request) {
            switch (request.kind) {
                case DELETION: {
                    AbstractExtensionProducer.this.removeFile(request.file);
                }
            }
        }
    }
}

