/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.ExtIssueMsg;
import manifold.api.fs.IFile;
import manifold.api.fs.cache.PathCache;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawStatement;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.api.type.ITypeManifold;
import manifold.api.util.JavacDiagnostic;
import manifold.ext.ExtensionManifold;
import manifold.ext.IExtensionClassProducer;
import manifold.ext.Model;
import manifold.ext.rt.ExtensionMethod;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.SourceJavaFileObject;

class ExtCodeGen {
    private JavaFileManager.Location _location;
    private final Model _model;
    private final String _fqn;
    private final boolean _genStubs;
    private String _existingSource;

    ExtCodeGen(JavaFileManager.Location location, Model model, String topLevelFqn, boolean genStubs, String existingSource) {
        this._location = location;
        this._model = model;
        this._fqn = topLevelFqn;
        this._genStubs = genStubs;
        this._existingSource = existingSource;
    }

    private IModule getModule() {
        return this._model.getTypeManifold().getModule();
    }

    String make(JavaFileManager.Location location, DiagnosticListener<JavaFileObject> errorHandler) {
        SrcClass srcExtended;
        if (!this._existingSource.isEmpty()) {
            srcExtended = this.makeStubFromSource();
        } else {
            srcExtended = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(this._fqn, location, errorHandler);
            srcExtended.setBinary(true);
        }
        return this.addExtensions(srcExtended, errorHandler);
    }

    private SrcClass makeStubFromSource() {
        ArrayList trees = new ArrayList();
        this._model.getHost().getJavaParser().parseText(this._existingSource, trees, null, null, null);
        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)((CompilationUnitTree)trees.get(0)).getTypeDecls().get(0);
        SrcClass srcExtended = (SrcClass)new SrcClass(this._fqn, classDecl.getKind() == Tree.Kind.CLASS ? AbstractSrcClass.Kind.Class : AbstractSrcClass.Kind.Interface).modifiers(classDecl.getModifiers().getFlags());
        if (classDecl.extending != null) {
            srcExtended.superClass(classDecl.extending.toString());
        }
        for (JCTree.JCExpression iface : classDecl.implementing) {
            srcExtended.addInterface(iface.toString());
        }
        return srcExtended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addExtensions(SrcClass extendedClass, DiagnosticListener<JavaFileObject> errorHandler) {
        boolean methodExtensions = false;
        boolean interfaceExtensions = false;
        boolean annotationExtensions = false;
        Set<String> allExtensions = this.findAllExtensions();
        this._model.pushProcessing(this._fqn);
        try {
            String string;
            Iterator<String> iterator = allExtensions.iterator();
            while (iterator.hasNext()) {
                String extensionFqn = iterator.next();
                SrcClass srcExtension = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(extensionFqn);
                if (srcExtension != null) {
                    for (AbstractSrcMethod method : srcExtension.getMethods()) {
                        this.addExtensionMethod(method, extendedClass, errorHandler);
                        methodExtensions = true;
                    }
                    for (SrcType iface : srcExtension.getInterfaces()) {
                        this.addExtensionInteface(iface, extendedClass);
                        interfaceExtensions = true;
                    }
                    for (SrcAnnotationExpression anno : srcExtension.getAnnotations()) {
                        this.addExtensionAnnotation(anno, extendedClass);
                        annotationExtensions = true;
                    }
                    continue;
                }
                iterator.remove();
            }
            if (!this._existingSource.isEmpty()) {
                if (allExtensions.isEmpty()) {
                    string = this._existingSource;
                    return string;
                }
                string = this.addExtensionsToExistingClass(extendedClass, methodExtensions, interfaceExtensions, annotationExtensions);
                return string;
            }
            string = extendedClass.render(new StringBuilder(), 0).toString();
            return string;
        }
        finally {
            this._model.popProcessing(this._fqn);
        }
    }

    private String addExtensionsToExistingClass(SrcClass srcClass, boolean methodExtensions, boolean interfaceExtensions, boolean annotationExtensions) {
        StringBuilder sb = new StringBuilder();
        if (methodExtensions) {
            this.addExtensionMethodsToExistingClass(srcClass, sb);
        }
        if (interfaceExtensions) {
            this.addExtensionInterfacesToExistingClass(srcClass, sb);
        }
        if (annotationExtensions) {
            this.addExtensionAnnotationsToExistingClass(srcClass, sb);
        }
        return sb.toString();
    }

    private void addExtensionInterfacesToExistingClass(SrcClass srcClass, StringBuilder sb) {
        String start = (srcClass.isInterface() ? "interface " : "class ") + srcClass.getSimpleName();
        int iStart = sb.indexOf(start);
        int iBrace = sb.indexOf("{", iStart);
        StringBuilder sbSrcClass = new StringBuilder();
        srcClass.render(sbSrcClass, 0);
        int iSrcClassStart = sbSrcClass.indexOf(start);
        int iSrcClassBrace = sbSrcClass.indexOf("{", iSrcClassStart);
        String fromSrcClass = sbSrcClass.substring(iSrcClassStart, iSrcClassBrace);
        sb.replace(iStart, iBrace, fromSrcClass);
    }

    private void addExtensionAnnotationsToExistingClass(SrcClass srcClass, StringBuilder sb) {
        int iStart;
        if (srcClass.getAnnotations().isEmpty()) {
            return;
        }
        StringBuilder sbAnnos = new StringBuilder();
        for (SrcAnnotationExpression anno : srcClass.getAnnotations()) {
            anno.render(sbAnnos, 0).append('\n');
        }
        String start = (srcClass.isInterface() ? "interface " : "class ") + srcClass.getSimpleName();
        for (iStart = sb.indexOf(start); iStart != 0 && sb.charAt(iStart) != '\n'; --iStart) {
        }
        if (sb.charAt(iStart) == '\n') {
            ++iStart;
        }
        sb.insert(iStart, sbAnnos);
    }

    private void addExtensionMethodsToExistingClass(SrcClass srcClass, StringBuilder sb) {
        int iBrace = this._existingSource.lastIndexOf(125);
        sb.append(this._existingSource, 0, iBrace);
        for (AbstractSrcMethod method : srcClass.getMethods()) {
            method.render(sb, 2);
        }
        sb.append("\n}");
    }

    private Set<String> findAllExtensions() {
        if (this._model.isProcessing(this._fqn)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> fqns = new LinkedHashSet<String>();
        this.findExtensionsOnDisk(fqns);
        this.findExtensionsFromExtensionClassProviders(fqns);
        return fqns;
    }

    private void findExtensionsOnDisk(Set<String> fqns) {
        PathCache pathCache = this.getModule().getPathCache();
        for (IFile file : this._model.getFiles()) {
            Set fqn = pathCache.getFqnForFile(file);
            for (String f : fqn) {
                if (f == null) continue;
                String innerExtFqn = this.findInnerClassInExtension(f);
                fqns.add(innerExtFqn);
            }
        }
    }

    private String findInnerClassInExtension(String extensionFqn) {
        String toplevel = this._model.getFqn();
        if (toplevel.length() == this._fqn.length()) {
            return extensionFqn;
        }
        int index = this._fqn.indexOf(toplevel);
        if (index >= 0) {
            return extensionFqn + this._fqn.substring(toplevel.length());
        }
        return extensionFqn;
    }

    private void findExtensionsFromExtensionClassProviders(Set<String> fqns) {
        ExtensionManifold extensionManifold = this._model.getTypeManifold();
        for (ITypeManifold tm : extensionManifold.getModule().getTypeManifolds()) {
            if (tm == extensionManifold || !(tm instanceof IExtensionClassProducer)) continue;
            Set<String> extensionClasses = ((IExtensionClassProducer)tm).getExtensionClasses(this._model.getFqn());
            extensionClasses = extensionClasses.stream().map(e -> this.findInnerClassInExtension((String)e)).collect(Collectors.toSet());
            fqns.addAll(extensionClasses);
        }
    }

    private void addExtensionInteface(SrcType iface, SrcClass extendedType) {
        extendedType.addInterface(iface);
    }

    private void addExtensionAnnotation(SrcAnnotationExpression anno, SrcClass extendedType) {
        if (anno.getAnnotationType().equals(Extension.class.getName())) {
            return;
        }
        if (extendedType.getAnnotations().stream().noneMatch(e -> e.getAnnotationType().equals(anno.getAnnotationType()))) {
            extendedType.addAnnotation(anno.copy());
        }
    }

    private void addExtensionMethod(AbstractSrcMethod method, SrcClass extendedType, DiagnosticListener<JavaFileObject> errorHandler) {
        int i;
        int i2;
        if (!this.isExtensionMethod(method, extendedType)) {
            return;
        }
        boolean delegateCalls = !this._existingSource.isEmpty() && !this._genStubs;
        boolean isInstanceExtensionMethod = this.isInstanceExtensionMethod(method, extendedType);
        SrcMethod srcMethod = new SrcMethod((AbstractSrcClass)extendedType);
        long modifiers = method.getModifiers();
        if (extendedType.isInterface() && isInstanceExtensionMethod) {
            modifiers |= 0x80000000000L;
        }
        if (isInstanceExtensionMethod) {
            modifiers &= 0xFFFFFFFFFFFFFFF7L;
        }
        srcMethod.modifiers(modifiers);
        if (!delegateCalls) {
            srcMethod.addAnnotation(new SrcAnnotationExpression(ExtensionMethod.class).addArgument("extensionClass", String.class, (Object)((SrcClass)method.getOwner()).getName()).addArgument("isStatic", Boolean.TYPE, (Object)(!isInstanceExtensionMethod ? 1 : 0)));
        }
        srcMethod.returns(method.getReturnType());
        String name = method.getSimpleName();
        srcMethod.name(name);
        List typeParams = method.getTypeVariables();
        int extendedTypeVarCount = extendedType.getTypeVariables().size();
        int n = i2 = isInstanceExtensionMethod ? extendedTypeVarCount : 0;
        while (i2 < typeParams.size()) {
            SrcType typeVar = (SrcType)typeParams.get(i2);
            srcMethod.addTypeVar(typeVar);
            ++i2;
        }
        List params = method.getParameters();
        int n2 = i = isInstanceExtensionMethod ? 1 : 0;
        while (i < params.size()) {
            SrcParameter param = (SrcParameter)params.get(i);
            srcMethod.addParam(param.getSimpleName(), param.getType());
            ++i;
        }
        for (Object throwType : method.getThrowTypes()) {
            srcMethod.addThrowType((SrcType)throwType);
        }
        if (delegateCalls) {
            this.delegateCall(method, isInstanceExtensionMethod, srcMethod);
        } else {
            srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("throw new " + RuntimeException.class.getSimpleName() + "(\"Should not exist at runtime!\");")));
        }
        extendedType.addMethod((AbstractSrcMethod)srcMethod);
    }

    private void delegateCall(AbstractSrcMethod method, boolean isInstanceExtensionMethod, SrcMethod srcMethod) {
        StringBuilder call = new StringBuilder();
        SrcType returnType = srcMethod.getReturnType();
        if (returnType != null && !returnType.getName().equals(Void.TYPE.getName())) {
            call.append("return ");
        }
        String extClassName = ((SrcClass)method.getOwner()).getName();
        call.append(extClassName).append('.').append(srcMethod.getSimpleName()).append('(');
        if (isInstanceExtensionMethod) {
            call.append("this");
        }
        for (SrcParameter param : srcMethod.getParameters()) {
            if (call.charAt(call.length() - 1) != '(') {
                call.append(", ");
            }
            call.append(param.getSimpleName());
        }
        call.append(");\n");
        srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText(call.toString())));
    }

    private boolean warnIfDuplicate(AbstractSrcMethod method, SrcClass extendedType, DiagnosticListener<JavaFileObject> errorHandler) {
        AbstractSrcMethod duplicate = this.findMethod(method, extendedType);
        if (duplicate == null) {
            return false;
        }
        ClassSymbols classSymbols = ClassSymbols.instance((IModule)this.getModule());
        Context ctx = JavacPlugin.instance() == null ? classSymbols.getJavacTask_PlainFileMgr().getContext() : JavacPlugin.instance().getContext();
        Symbol.ClassSymbol sym = IDynamicJdk.instance().getLoadedClass(ctx, ((SrcClass)method.getOwner()).getName());
        if (sym == null) {
            return false;
        }
        JavaFileObject file = sym.sourcefile;
        SrcAnnotationExpression anno = duplicate.getAnnotation(ExtensionMethod.class);
        if (anno != null) {
            errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic((JavaFileObject)(file.toUri().getScheme() == null ? null : new SourceJavaFileObject(file.toUri())), Diagnostic.Kind.WARNING, 0L, 0L, 0L, ExtIssueMsg.MSG_EXTENSION_DUPLICATION.get(new Object[]{method.signature(), ((SrcClass)method.getOwner()).getName(), anno.getArgument("extensionClass").getValue()})));
        } else {
            errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic((JavaFileObject)(file.toUri().getScheme() == null ? null : new SourceJavaFileObject(file.toUri())), Diagnostic.Kind.WARNING, 0L, 0L, 0L, ExtIssueMsg.MSG_EXTENSION_SHADOWS.get(new Object[]{method.signature(), ((SrcClass)method.getOwner()).getName(), extendedType.getName()})));
        }
        return true;
    }

    private AbstractSrcMethod findMethod(AbstractSrcMethod method, SrcClass extendedType) {
        AbstractSrcMethod duplicate = null;
        block0: for (AbstractSrcMethod m : extendedType.getMethods()) {
            if (!m.getSimpleName().equals(method.getSimpleName()) || m.getParameters().size() != method.getParameters().size() - 1) continue;
            List parameters = method.getParameters();
            List params = m.getParameters();
            for (int i = 1; i < parameters.size(); ++i) {
                SrcParameter param = (SrcParameter)parameters.get(i);
                SrcParameter p = (SrcParameter)params.get(i - 1);
                if (!param.getType().equals((Object)p.getType())) continue block0;
            }
            duplicate = m;
            break;
        }
        if (duplicate == null) {
            SrcType superClass;
            if (!extendedType.isInterface() && (superClass = extendedType.getSuperClass()) != null && superClass.getName().equals(Object.class.getName())) {
                SrcClass superSrcClass = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(superClass.getName());
                duplicate = this.findMethod(method, superSrcClass);
            }
            if (duplicate == null) {
                for (SrcType iface : extendedType.getInterfaces()) {
                    SrcClass superIface = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(iface.getName());
                    duplicate = this.findMethod(method, superIface);
                    if (duplicate == null) continue;
                    break;
                }
            }
        }
        return duplicate;
    }

    private boolean isExtensionMethod(AbstractSrcMethod method, SrcClass extendedType) {
        if (!Modifier.isStatic((int)method.getModifiers()) || Modifier.isPrivate((int)method.getModifiers())) {
            return false;
        }
        if (method.hasAnnotation(Extension.class)) {
            return true;
        }
        return this.hasThisAnnotation(method, extendedType);
    }

    private boolean isInstanceExtensionMethod(AbstractSrcMethod method, SrcClass extendedType) {
        if (!Modifier.isStatic((int)method.getModifiers()) || Modifier.isPrivate((int)method.getModifiers())) {
            return false;
        }
        return this.hasThisAnnotation(method, extendedType);
    }

    private boolean hasThisAnnotation(AbstractSrcMethod method, SrcClass extendedType) {
        List params = method.getParameters();
        if (params.size() == 0) {
            return false;
        }
        SrcParameter param = (SrcParameter)params.get(0);
        if (!param.hasAnnotation(This.class)) {
            return false;
        }
        return param.getType().getName().endsWith(extendedType.getSimpleName()) || this.isArrayExtension(param, extendedType);
    }

    private boolean isArrayExtension(SrcParameter param, SrcClass extendedType) {
        return extendedType.getName().equals("manifold.rt.api.Array") && param.getType().getFqName().equals(Object.class.getTypeName());
    }
}

