/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.type.IModel;
import manifold.ext.ExtensionManifold;

public class Model
implements IModel {
    private final ExtensionManifold _sp;
    private final String _fqnExtended;
    private Set<IFile> _files;
    private Stack<String> _processing;

    Model(String extendedFqn, Set<IFile> files, ExtensionManifold sp) {
        this._fqnExtended = extendedFqn;
        this._files = new HashSet<IFile>(files);
        this._processing = new Stack();
        this._sp = sp;
    }

    public IManifoldHost getHost() {
        return this.getTypeManifold().getModule().getHost();
    }

    public String getFqn() {
        return this._fqnExtended;
    }

    public Set<IFile> getFiles() {
        if (this._files == null) {
            this._files = new HashSet<IFile>();
        }
        return this._files;
    }

    public void addFile(IFile file) {
        if (!this.getFiles().add(file)) {
            // empty if block
        }
    }

    public void removeFile(IFile file) {
        if (!this.getFiles().remove(file)) {
            throw new IllegalStateException("Model does not contain " + file.getName());
        }
    }

    public void updateFile(IFile file) {
        this.getFiles().remove(file);
        this.getFiles().add(file);
    }

    ExtensionManifold getTypeManifold() {
        return this._sp;
    }

    public boolean isProcessing(String fqn) {
        return this._processing.contains(fqn);
    }

    void pushProcessing(String fqn) {
        this._processing.push(fqn);
    }

    void popProcessing(String fqn) {
        String popped = this._processing.pop();
        if (!popped.equals(fqn)) {
            throw new IllegalStateException("Unbalanced stack operation");
        }
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
    }
}

