/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.type;

import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileUtil;
import manifold.graphql.type.GqlIssue;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.IIssueContainer;

public class GqlIssueContainer
implements IIssueContainer {
    private final IFile _file;
    private final List<IIssue> _issues = new ArrayList<IIssue>();

    public GqlIssueContainer(List<GraphQLError> errors, IFile file) {
        this._file = file;
        this.addIssues(errors);
    }

    public List<IIssue> getIssues() {
        return this._issues;
    }

    public List<IIssue> getWarnings() {
        return Collections.emptyList();
    }

    public List<IIssue> getErrors() {
        return this.getIssues();
    }

    public void addIssues(List<GraphQLError> errors) {
        for (GraphQLError e : errors) {
            Optional loc = e.getLocations().stream().findFirst();
            int line = 0;
            int column = 0;
            int offset = 0;
            if (loc.isPresent()) {
                SourceLocation sourceLocation = (SourceLocation)loc.get();
                line = sourceLocation.getLine();
                column = sourceLocation.getColumn();
                offset = IFileUtil.findOffset((IFile)this._file, (int)line, (int)column);
            }
            this._issues.add(new GqlIssue(IIssue.Kind.Error, offset, line, column, e.getMessage()));
        }
    }

    public boolean isEmpty() {
        return this._issues == null;
    }
}

