/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt.api;

import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import manifold.json.rt.Json;
import manifold.json.rt.api.IJsonBindingsTranslator;
import manifold.json.rt.extensions.java.net.URL.ManUrlExt;
import manifold.rt.api.util.StreamUtil;

public class Loader<E> {
    public E fromJson(String jsonText) {
        return (E)Json.fromJson(jsonText);
    }

    public E fromJsonUrl(String urlBase, String ... urlSuffix) {
        try {
            StringBuilder url = new StringBuilder(urlBase);
            if (urlSuffix != null) {
                Arrays.stream(urlSuffix).forEach(url::append);
            }
            return (E)ManUrlExt.getJsonContent(new URL(url.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromJsonUrl(URL url) {
        return (E)ManUrlExt.getJsonContent(url);
    }

    public E fromJsonFile(File file) {
        try {
            return this.fromJsonUrl(file.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromJsonReader(Reader reader) {
        try {
            return (E)Json.fromJson(StreamUtil.getContent((Reader)reader));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromYaml(String yamlText) {
        IJsonBindingsTranslator yaml = IJsonBindingsTranslator.get("YAML");
        return (E)yaml.toBindings(yamlText);
    }

    public E fromYamlUrl(String urlBase, String ... urlSuffix) {
        try {
            StringBuilder url = new StringBuilder(urlBase);
            if (urlSuffix != null) {
                Arrays.stream(urlSuffix).forEach(url::append);
            }
            return (E)ManUrlExt.getYamlContent(new URL(url.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromYamlUrl(URL url) {
        return (E)ManUrlExt.getYamlContent(url);
    }

    public E fromYamlFile(File file) {
        try {
            return this.fromYamlUrl(file.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromYamlReader(Reader reader) {
        try {
            IJsonBindingsTranslator yaml = IJsonBindingsTranslator.get("YAML");
            return (E)yaml.toBindings(StreamUtil.getContent((Reader)reader));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromXml(String xmlText) {
        IJsonBindingsTranslator xml = IJsonBindingsTranslator.get("XML");
        return (E)xml.toBindings(xmlText);
    }

    public E fromXmlUrl(String urlBase, String ... urlSuffix) {
        try {
            StringBuilder url = new StringBuilder(urlBase);
            if (urlSuffix != null) {
                Arrays.stream(urlSuffix).forEach(url::append);
            }
            return (E)ManUrlExt.getXmlContent(new URL(url.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromXmlUrl(URL url) {
        return (E)ManUrlExt.getXmlContent(url);
    }

    public E fromXmlFile(File file) {
        try {
            return this.fromXmlUrl(file.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromXmlReader(Reader reader) {
        try {
            IJsonBindingsTranslator xml = IJsonBindingsTranslator.get("XML");
            return (E)xml.toBindings(StreamUtil.getContent((Reader)reader));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromCsv(String csvText) {
        IJsonBindingsTranslator csv = IJsonBindingsTranslator.get("CSV");
        return (E)csv.toBindings(csvText);
    }

    public E fromCsvUrl(String urlBase, String ... urlSuffix) {
        try {
            StringBuilder url = new StringBuilder(urlBase);
            if (urlSuffix != null) {
                Arrays.stream(urlSuffix).forEach(url::append);
            }
            return (E)ManUrlExt.getCsvContent(new URL(url.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromCsvUrl(URL url) {
        return (E)ManUrlExt.getCsvContent(url);
    }

    public E fromCsvFile(File file) {
        try {
            return this.fromCsvUrl(file.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromCsvReader(Reader reader) {
        try {
            IJsonBindingsTranslator csv = IJsonBindingsTranslator.get("CSV");
            return (E)csv.toBindings(StreamUtil.getContent((Reader)reader));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

