/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import manifold.ext.rt.api.ICallHandler;
import manifold.json.rt.api.IJsonFormatTypeCoercer;

public class BigNumberCoercer
implements IJsonFormatTypeCoercer {
    private static final Map<String, Class<?>> ALL = new HashMap<String, Class<?>>(){
        {
            this.put("big-integer", BigInteger.class);
            this.put("big-decimal", BigDecimal.class);
        }
    };

    @Override
    public Map<String, Class<?>> getFormats() {
        return ALL;
    }

    public Object coerce(Object value, Class<?> type) {
        if (type == BigInteger.class && value instanceof String) {
            return "0".equals(value) ? BigInteger.ZERO : new BigInteger((String)value);
        }
        if (type == BigDecimal.class && value instanceof String) {
            return "0".equals(value) ? BigDecimal.ZERO : new BigDecimal((String)value);
        }
        if ((value instanceof BigInteger || value instanceof BigDecimal) && type == String.class) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }

    public Object toBindingValue(Object value) {
        if (value instanceof BigInteger || value instanceof BigDecimal) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }
}

