/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt.api;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import manifold.ext.rt.api.IBindingsBacked;
import manifold.rt.api.Bindings;

public class DataBindings
implements Bindings {
    private Map<String, Object> _map;

    public DataBindings(Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        this._map = map;
    }

    public DataBindings() {
        this(new LinkedHashMap<String, Object>());
    }

    public DataBindings(int size) {
        this(new LinkedHashMap<String, Object>(size));
    }

    public Object put(String name, Object value) {
        if (value instanceof IBindingsBacked) {
            throw new IllegalArgumentException("Non-raw bindings: " + value);
        }
        this.checkKey(name);
        return this._map.put(name, value);
    }

    public void putAll(Map<? extends String, ?> toMerge) {
        if (toMerge == null) {
            throw new NullPointerException("toMerge map is null");
        }
        for (Map.Entry<String, ?> entry : toMerge.entrySet()) {
            String key = entry.getKey();
            this.checkKey(key);
            this.put(key, entry.getValue());
        }
    }

    public void clear() {
        this._map.clear();
    }

    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this._map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this._map.entrySet();
    }

    public Object get(Object key) {
        this.checkKey(key);
        return this._map.get(key);
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Set<String> keySet() {
        return this._map.keySet();
    }

    public Object remove(Object key) {
        this.checkKey(key);
        return this._map.remove(key);
    }

    public int size() {
        return this._map.size();
    }

    public Collection<Object> values() {
        return this._map.values();
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key should be a String");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("key can not be empty");
        }
    }

    public boolean equals(Object o) {
        if (o instanceof IBindingsBacked) {
            o = ((IBindingsBacked)o).getBindings();
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataBindings that = (DataBindings)o;
        return Objects.equals(this._map, that._map);
    }

    public int hashCode() {
        return Objects.hash(this._map);
    }
}

