/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.csv.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import manifold.api.csv.parser.CsvToken;
import manifold.api.csv.parser.DataStats;
import manifold.api.util.ManDateTimeUtil;
import manifold.api.util.ManStringUtil;

public class CsvTokenizer {
    private static final char[] SEPARATORS = new char[]{',', ';', ':', '|', '\t'};
    private CharSequence _content;
    private Boolean _hasHeader;
    private char _separator;
    private boolean _whitespace;
    private List<Class> _types;
    private boolean _sampling;
    private int _length;
    private int _pos;
    private int _line;
    private CsvToken _prevToken;

    public CsvTokenizer(CharSequence content) {
        this(content, null);
    }

    public CsvTokenizer(CharSequence content, Boolean header) {
        this._content = content;
        this._length = content.length();
        this._hasHeader = header;
        this.resetPos();
        this.sample();
    }

    private void resetPos() {
        this._pos = -1;
        this._line = 1;
        this._prevToken = null;
    }

    public boolean hasHeader() {
        return this._hasHeader;
    }

    public CsvToken nextToken() {
        char c = this.nextChar();
        if (!this._whitespace) {
            c = this.skipSpaces(c);
        }
        int offset = this._pos;
        int line = this._line;
        StringBuilder value = new StringBuilder();
        boolean quoted = false;
        while (true) {
            switch (c) {
                case '\"': {
                    value.append(c);
                    if (value.length() == 1) {
                        quoted = true;
                        break;
                    }
                    if (!quoted || (c = this.nextChar()) == '\"') break;
                    int end = this._pos;
                    if ((c = this.skipSpaces(c)) != this._separator && c != '\n' && c != '\u0000') {
                        if (this._sampling && this.isPossibleSeparator(c)) {
                            if (this.isEol()) {
                                ++this._line;
                            }
                            this._prevToken = new CsvToken(CsvToken.Type.Quoted, value.toString(), line, offset, end - offset, this._pos, c);
                            return this._prevToken;
                        }
                        this._pos = end - 1;
                        quoted = false;
                        break;
                    }
                    if (this.isEol()) {
                        ++this._line;
                    }
                    this._prevToken = new CsvToken(CsvToken.Type.Quoted, value.toString(), line, offset, end - offset, this._pos, c);
                    return this._prevToken;
                }
                case '\t': 
                case ',': 
                case ':': 
                case ';': 
                case '|': {
                    if (quoted || c != this._separator) {
                        value.append(c);
                        break;
                    }
                    this._prevToken = new CsvToken(CsvToken.Type.NotQuoted, value.toString(), line, offset, this._pos - offset, this._pos, c);
                    return this._prevToken;
                }
                case '\n': {
                    boolean emptyLine;
                    ++this._line;
                    if (quoted) {
                        value.append(c);
                        break;
                    }
                    int end = this._content.charAt(this._pos - 1) == '\r' ? this._pos - 1 : this._pos;
                    int length = end - offset;
                    boolean bl = emptyLine = length == 0 && (this._prevToken == null || this._prevToken.isLastInRecord());
                    if (emptyLine) break;
                    this._prevToken = new CsvToken(CsvToken.Type.NotQuoted, value.toString(), line, offset, length, this._pos, c);
                    return this._prevToken;
                }
                case '\u0000': {
                    return new CsvToken(quoted ? CsvToken.Type.Quoted : CsvToken.Type.NotQuoted, value.toString(), line, offset, this._pos - offset, this._pos, c);
                }
                default: {
                    value.append(c);
                }
            }
            c = this.nextChar();
        }
    }

    private boolean isPossibleSeparator(char c) {
        for (int i = 0; i < SEPARATORS.length; ++i) {
            if (c != SEPARATORS[i]) continue;
            return true;
        }
        return false;
    }

    private char skipSpaces(char c) {
        while (c == ' ' || c == '\t' && c != this._separator) {
            c = this.nextChar();
        }
        return c;
    }

    private void sample() {
        this._sampling = true;
        this._separator = this.inferSeparator();
        this.resetPos();
        this._whitespace = this.inferRetainLeadingTrailingWhitespace();
        this.resetPos();
        this._hasHeader = this._hasHeader == null ? this.inferHeader() : this._hasHeader.booleanValue();
        this.resetPos();
        this._types = this.inferDataTypes();
        this.resetPos();
        this._sampling = false;
    }

    private boolean inferHeader() {
        CsvToken token;
        ArrayList<DataStats> header = new ArrayList<DataStats>();
        do {
            if ((token = this.nextToken()).isEmpty()) {
                return false;
            }
            header.add(new DataStats(token));
        } while (!token.isLastInRecord());
        int fieldCount = 0;
        int diffCount = 0;
        int row = 0;
        int i = 0;
        while (row < 100) {
            if (i == header.size()) {
                return false;
            }
            CsvToken token2 = this.nextToken();
            DataStats stats = (DataStats)header.get(i);
            if (!token2.isEmpty()) {
                ++fieldCount;
                if (!stats.isSimilar(token2)) {
                    ++diffCount;
                }
            }
            if (token2.isLastInRecord()) {
                boolean emptyLine;
                boolean bl = emptyLine = i == 0 && token2.getValue().isEmpty();
                if (!emptyLine && i != header.size() - 1) {
                    return false;
                }
                if (token2.isEof()) break;
                ++row;
                i = 0;
                continue;
            }
            ++i;
        }
        return fieldCount != 0 && diffCount * 100 / fieldCount > 60;
    }

    private List<Class> inferDataTypes() {
        if (this._hasHeader.booleanValue()) {
            CsvToken token;
            while (!(token = this.nextToken()).isLastInRecord()) {
            }
        }
        ArrayList<Class> types = new ArrayList<Class>();
        int row = 0;
        int i = 0;
        while (row < 1000) {
            if (row > 0 && i == types.size()) {
                return null;
            }
            CsvToken token = this.nextToken();
            if (row == 0) {
                types.add(this.inferType(token.getData()));
            } else if (row <= 100 || row % 10 == 0) {
                types.set(i, this.mergeDataType(token.getData(), (Class)types.get(i)));
            }
            if (token.isLastInRecord()) {
                boolean emptyLine;
                boolean bl = emptyLine = i == 0 && token.getValue().isEmpty();
                if (!emptyLine && row > 0 && i != types.size() - 1) {
                    return null;
                }
                if (token.isEof()) break;
                ++row;
                i = 0;
                continue;
            }
            ++i;
        }
        for (int t = 0; t < types.size(); ++t) {
            if (types.get(t) != null) continue;
            types.set(t, String.class);
        }
        return types;
    }

    private Class mergeDataType(String data, Class existingType) {
        if (data.isEmpty()) {
            return this.mergeTypes(existingType, null);
        }
        Class inferredType = this.inferType(data);
        return this.mergeTypes(existingType, inferredType);
    }

    private Class mergeTypes(Class existingType, Class inferredType) {
        if (existingType == String.class) {
            return existingType;
        }
        if (inferredType == existingType || existingType == null) {
            return inferredType;
        }
        if (inferredType == null) {
            return existingType;
        }
        if (existingType == Boolean.class) {
            return String.class;
        }
        if (existingType == Integer.class) {
            if (inferredType == Long.class || inferredType == Double.class || inferredType == BigInteger.class || inferredType == BigDecimal.class) {
                return inferredType;
            }
        } else if (existingType == Long.class) {
            if (inferredType == Integer.class) {
                return existingType;
            }
            if (inferredType == Double.class || inferredType == BigInteger.class || inferredType == BigDecimal.class) {
                return inferredType;
            }
        } else if (existingType == BigInteger.class) {
            if (inferredType == Integer.class || inferredType == Long.class) {
                return existingType;
            }
            if (inferredType == Double.class) {
                return BigDecimal.class;
            }
            if (inferredType == BigDecimal.class) {
                return inferredType;
            }
        } else if (existingType == Double.class) {
            if (inferredType == Integer.class || inferredType == Long.class) {
                return existingType;
            }
            if (inferredType == BigInteger.class) {
                return BigDecimal.class;
            }
            if (inferredType == BigDecimal.class) {
                return inferredType;
            }
        } else if (existingType == BigDecimal.class && (inferredType == Integer.class || inferredType == Long.class || inferredType == Double.class || inferredType == BigInteger.class)) {
            return existingType;
        }
        return String.class;
    }

    private Class inferType(String data) {
        Class type = data.isEmpty() ? null : (!ManStringUtil.isAlpha((String)data) ? (this.isInteger(data) ? Integer.class : (this.isLong(data) ? Long.class : (this.isBigInteger(data) ? BigInteger.class : (this.isDouble(data) ? Double.class : (this.isBigDecimal(data) ? BigDecimal.class : (this.isDateTime(data) ? LocalDateTime.class : (this.isDate(data) ? LocalDate.class : (this.isTime(data) ? LocalTime.class : String.class)))))))) : (this.isBoolean(data) ? Boolean.class : String.class));
        return type;
    }

    private boolean isDateTime(String data) {
        return null != ManDateTimeUtil.parseDateTime((String)data);
    }

    private boolean isDate(String data) {
        return null != ManDateTimeUtil.parseDate((String)data);
    }

    private boolean isTime(String data) {
        return null != ManDateTimeUtil.parseTime((String)data);
    }

    private boolean isInteger(String data) {
        try {
            Integer.parseInt(data);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isLong(String data) {
        try {
            Long.parseLong(data);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isBigInteger(String data) {
        try {
            new BigInteger(data);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isDouble(String data) {
        try {
            Double.parseDouble(data);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isBigDecimal(String data) {
        try {
            new BigDecimal(data);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isBoolean(String data) {
        return "true".equalsIgnoreCase(data) || "false".equalsIgnoreCase(data) || "yes".equalsIgnoreCase(data) || "no".equalsIgnoreCase(data) || "on".equalsIgnoreCase(data) || "off".equalsIgnoreCase(data);
    }

    private boolean inferRetainLeadingTrailingWhitespace() {
        HashMap<Integer, Integer> spacesToOccurrence = new HashMap<Integer, Integer>();
        this.mapSpacesToOccurrences(spacesToOccurrence);
        int[] best = new int[]{0, 0};
        spacesToOccurrence.forEach((key, value) -> {
            if (value.compareTo(best[1]) > 0) {
                best[0] = key;
                best[1] = value;
            }
        });
        int total = spacesToOccurrence.values().size();
        if (total == 0 || best[1] * 100 / total > 80) {
            return best[0] == 0;
        }
        return true;
    }

    private void mapSpacesToOccurrences(Map<Integer, Integer> spacesToOccurrance) {
        this._whitespace = true;
        int row = 0;
        boolean first = true;
        while (row < 10) {
            CsvToken token = this.nextToken();
            if (!first) {
                int count = this.countLeadingSpaces(token);
                Integer existing = spacesToOccurrance.get(count);
                spacesToOccurrance.put(count, existing == null ? count : existing + 1);
            } else {
                first = false;
            }
            if (!token.isLastInRecord()) continue;
            if (token.isEof()) break;
            first = true;
            ++row;
        }
    }

    private int countLeadingSpaces(CsvToken token) {
        char c;
        int spaces = 0;
        String value = token.getValue();
        for (int i = 0; i < value.length() && ((c = value.charAt(i)) == ' ' || c == '\t'); ++i) {
            ++spaces;
        }
        return spaces;
    }

    private char inferSeparator() {
        char cMax = '\u0000';
        int max = -1;
        for (char separator : SEPARATORS) {
            int result = this.sampleSeparator(separator);
            if (result > max) {
                max = result;
                cMax = separator;
            }
            this.resetPos();
        }
        if (max == -1) {
            cMax = ',';
        }
        return cMax;
    }

    public boolean isEol() {
        if (this._pos < 0 || this.isEof()) {
            return false;
        }
        if (this._content.charAt(this._pos) == '\n') {
            return true;
        }
        if (this._content.charAt(this._pos) == '\r') {
            return this._length - 1 == this._pos || this._content.charAt(this._pos + 1) != '\n';
        }
        return false;
    }

    public boolean isEof() {
        return this._pos == this._content.length();
    }

    private int sampleSeparator(char separator) {
        this._separator = separator;
        int recordSize = 0;
        int count = 0;
        int row = 0;
        while (row < 10) {
            ++count;
            CsvToken token = this.nextToken();
            if (token.isLastInRecord()) {
                boolean emptyLine;
                boolean bl = emptyLine = count == 1 && token.getValue().isEmpty();
                if (!emptyLine) {
                    if (recordSize == 0) {
                        recordSize = count;
                    }
                    if (count != recordSize) {
                        return -1;
                    }
                    if (token.isEof()) break;
                }
                count = 0;
                ++row;
                continue;
            }
            if (token.getSeparatorChar() == separator) continue;
            return -1;
        }
        return recordSize;
    }

    private char nextChar() {
        char c = this._rawNextChar();
        if (c == '\r') {
            c = this._rawNextChar();
            if (c == '\n') {
                return c;
            }
            c = '\n';
            --this._pos;
            return c;
        }
        return c;
    }

    private char _rawNextChar() {
        if (this._pos < this._length) {
            ++this._pos;
        }
        if (this._pos == this._length) {
            return '\u0000';
        }
        if (this._pos > this._length) {
            throw new IllegalStateException("position > length");
        }
        return this._content.charAt(this._pos);
    }

    public List<Class> getTypes() {
        return this._types;
    }
}

