/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import manifold.json.extensions.java.net.URL.ManUrlExt;

public class Endpoint {
    private final String _urlBase;
    private final Proxy _proxy;

    public Endpoint(String urlBase) {
        this._urlBase = urlBase;
        this._proxy = Proxy.NO_PROXY;
    }

    public Endpoint(String urlBase, String proxyAddr, int proxyPort) {
        this(urlBase, proxyAddr, proxyPort, Proxy.Type.HTTP);
    }

    public Endpoint(String urlBase, String proxyAddr, Proxy.Type proxyType) {
        this(urlBase, proxyAddr, 8080, proxyType);
    }

    public Endpoint(String urlBase, String proxyAddr, int proxyPort, Proxy.Type proxyType) {
        this._urlBase = urlBase;
        this._proxy = new Proxy(proxyType, new InetSocketAddress(proxyAddr, proxyPort));
    }

    private Endpoint(String urlBase, Proxy proxy) {
        this._urlBase = urlBase;
        this._proxy = proxy;
    }

    public Endpoint withUrlSuffix(String urlSuffix) {
        return new Endpoint(this._urlBase + urlSuffix, this._proxy);
    }

    public URLConnection openConnection() throws IOException {
        return new URL(this._urlBase).openConnection(this._proxy);
    }

    public Object sendCsvRequest(String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        try {
            return ManUrlExt.sendCsvRequest(new URL(this._urlBase), this._proxy, httpMethod, jsonValue, headers, timeout);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object sendJsonRequest(String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        try {
            return ManUrlExt.sendJsonRequest(new URL(this._urlBase), this._proxy, httpMethod, jsonValue, headers, timeout);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object sendPlainTextRequest(String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        try {
            return ManUrlExt.sendPlainTextRequest(new URL(this._urlBase), this._proxy, httpMethod, jsonValue, headers, timeout);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object sendXmlRequest(String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        try {
            return ManUrlExt.sendXmlRequest(new URL(this._urlBase), this._proxy, httpMethod, jsonValue, headers, timeout);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object sendYamlRequest(String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        try {
            return ManUrlExt.sendYamlRequest(new URL(this._urlBase), this._proxy, httpMethod, jsonValue, headers, timeout);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

