/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.extensions.java.net.URL;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import manifold.api.csv.Csv;
import manifold.api.json.Json;
import manifold.api.util.StreamUtil;
import manifold.api.xml.Xml;
import manifold.api.yaml.Yaml;
import manifold.ext.ReflectionRuntimeMethods;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.json.extensions.javax.script.Bindings.ManBindingsExt;

@Extension
public class ManUrlExt {
    public static URL makeUrl(String url, Object jsonValue) {
        boolean firstParam = url.indexOf(63) < 0;
        StringBuilder sb = new StringBuilder();
        if (jsonValue instanceof Bindings) {
            for (Map.Entry entry : ((Bindings)jsonValue).entrySet()) {
                sb.append(firstParam ? (char)'?' : '&').append(entry.getKey()).append('=');
                Object value = entry.getValue();
                value = ManUrlExt.valueToJson(value);
                sb.append(value);
                firstParam = false;
            }
        } else if (jsonValue instanceof List) {
            for (Object value : (List)jsonValue) {
                sb.append(firstParam ? (char)'?' : '&');
                value = ManUrlExt.valueToJson(value);
                sb.append(value);
                firstParam = false;
            }
        } else if (jsonValue != null) {
            String value = ManUrlExt.encode(String.valueOf(jsonValue));
            sb.append(firstParam ? (char)'?' : '&').append(value);
        }
        try {
            return new URL(url + sb);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object valueToJson(Object value) {
        if (value instanceof Bindings) {
            value = ManBindingsExt.toJson((Bindings)value);
        } else if (value instanceof List) {
            value = ManBindingsExt.listToJson((List)value);
        }
        return ManUrlExt.encode(String.valueOf(value));
    }

    @Extension
    public static String encode(String urlPart) {
        try {
            return URLEncoder.encode(urlPart, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String sendRequest(URL url, String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        try {
            if (jsonValue != null && (httpMethod.equals("GET") || httpMethod.equals("DELETE"))) {
                url = ManUrlExt.makeUrl(url.toString(), jsonValue);
            }
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(httpMethod);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            headers.forEach(conn::setRequestProperty);
            conn.setConnectTimeout(timeout);
            if (jsonValue != null && !httpMethod.equals("GET") && !httpMethod.equals("DELETE")) {
                ManUrlExt.sendJsonValue(jsonValue, conn);
            }
            return ManUrlExt.receiveResponse(conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void sendJsonValue(Object jsonValue, HttpURLConnection conn) throws IOException {
        String json = Json.toJson(jsonValue);
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setDoOutput(true);
        try (OutputStream out = conn.getOutputStream();){
            out.write(bytes);
        }
    }

    private static String receiveResponse(HttpURLConnection conn) throws IOException {
        try (Reader in = StreamUtil.getInputStreamReader((InputStream)conn.getInputStream());){
            String string = StreamUtil.getContent((Reader)in);
            return string;
        }
    }

    public static Object sendJsonRequest(@This URL url, String httpMethod, Object jsonValue) {
        return ManUrlExt.sendJsonRequest(url, httpMethod, jsonValue, Collections.emptyMap(), 0);
    }

    public static Object sendJsonRequest(@This URL url, String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        return Json.fromJson(ManUrlExt.sendRequest(url, httpMethod, jsonValue, headers, timeout));
    }

    public static Object sendYamlRequest(@This URL url, String httpMethod, Object jsonValue) {
        return ManUrlExt.sendYamlRequest(url, httpMethod, jsonValue, Collections.emptyMap(), 0);
    }

    public static Object sendYamlRequest(@This URL url, String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        return Yaml.fromYaml(ManUrlExt.sendRequest(url, httpMethod, jsonValue, headers, timeout));
    }

    public static Object sendXmlRequest(@This URL url, String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        return Xml.fromXml(ManUrlExt.sendRequest(url, httpMethod, jsonValue, headers, timeout));
    }

    public static Object sendCsvRequest(@This URL url, String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        return Csv.fromCsv(ManUrlExt.sendRequest(url, httpMethod, jsonValue, headers, timeout));
    }

    public static String sendPlainTextRequest(@This URL url, String httpMethod, Object jsonValue) {
        return ManUrlExt.sendPlainTextRequest(url, httpMethod, jsonValue, Collections.emptyMap(), 0);
    }

    public static String sendPlainTextRequest(@This URL url, String httpMethod, Object jsonValue, Map<String, String> headers, int timeout) {
        return ManUrlExt.sendRequest(url, httpMethod, jsonValue, headers, timeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTextContent(@This URL thiz) {
        try (Reader reader = StreamUtil.getInputStreamReader((InputStream)thiz.openStream());){
            String string = StreamUtil.getContent((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBinaryContent(@This URL thiz) {
        try (InputStream stream = thiz.openStream();){
            byte[] byArray = StreamUtil.getContent((InputStream)stream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getJsonContent(@This URL thiz) {
        return Json.fromJson(ManUrlExt.getTextContent(thiz));
    }

    public static Object getYamlContent(@This URL thiz) {
        return Yaml.fromYaml(ManUrlExt.getTextContent(thiz));
    }

    public static Object getXmlContent(@This URL thiz) {
        return Xml.fromXml(ManUrlExt.getTextContent(thiz));
    }

    public static Object getCsvContent(@This URL thiz) {
        return Csv.fromCsv(ManUrlExt.getTextContent(thiz));
    }

    static {
        Object cls = null;
        ReflectionRuntimeMethods.setFieldStatic_Object(HttpURLConnection.class, (String)"methods", (Object)new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE", "PATCH"});
    }
}

