/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.codegen.schema;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import manifold.api.json.codegen.schema.Base64Encoding;
import manifold.api.json.codegen.schema.IJsonFormatTypeResolver;
import manifold.api.json.codegen.schema.JsonFormatType;
import manifold.api.json.codegen.schema.OctetEncoding;
import manifold.ext.api.ICallHandler;

public class BinaryFormatResolver
implements IJsonFormatTypeResolver {
    private static final JsonFormatType BINARY = new JsonFormatType("binary", OctetEncoding.class);
    private static final JsonFormatType BYTE = new JsonFormatType("byte", Base64Encoding.class);
    private static final List<JsonFormatType> ALL = Arrays.asList(BINARY, BYTE);

    @Override
    public Set<String> getFormats() {
        return ALL.stream().map(JsonFormatType::getName).collect(Collectors.toSet());
    }

    @Override
    public JsonFormatType resolveType(String format) {
        if (BINARY.getFormat().equals(format)) {
            return BINARY;
        }
        if (BYTE.getFormat().equals(format)) {
            return BYTE;
        }
        return null;
    }

    public Object coerce(Object value, Class<?> type) {
        if (type == OctetEncoding.class && value instanceof String) {
            return OctetEncoding.encoded((String)value);
        }
        if (type == Base64Encoding.class && value instanceof String) {
            return Base64Encoding.encoded((String)value);
        }
        if ((value instanceof OctetEncoding || value instanceof Base64Encoding) && type == String.class) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }

    public Object toBindingValue(Object value) {
        if (value instanceof OctetEncoding || value instanceof Base64Encoding) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }
}

