/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.android.syms;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import manifold.internal.javac.JavacPlugin;
import manifold.rt.api.util.StreamUtil;
import manifold.util.JreUtil;
import manifold.util.ManExceptionUtil;
import manifold.util.ReflectUtil;

class BuildConfigFinder {
    private static BuildConfigFinder INSTANCE = null;

    BuildConfigFinder() {
    }

    static BuildConfigFinder instance() {
        return INSTANCE == null ? (INSTANCE = new BuildConfigFinder()) : INSTANCE;
    }

    Map<String, String> loadBuildConfigSymbols() {
        if (JavacPlugin.instance() == null) {
            return Collections.emptyMap();
        }
        Map<String, String> symbols = this.loadBuildConfigSymbols_Source();
        if (symbols != null && !symbols.isEmpty()) {
            return symbols;
        }
        return BuildConfigFinder.instance().loadBuildConfigSymbols_Class();
    }

    private Map<String, String> loadBuildConfigSymbols_Source() {
        Collection fileObjects;
        if (JreUtil.isJava8()) {
            try {
                fileObjects = (Collection)ReflectUtil.field((Object)JavacPlugin.instance().getJavacTask(), (String)"fileObjects").get();
            }
            catch (Throwable t) {
                return Collections.emptyMap();
            }
        } else {
            Object arguments = ReflectUtil.method((String)"com.sun.tools.javac.main.Arguments", (String)"instance", (Class[])new Class[]{Context.class}).invokeStatic(new Object[]{JavacPlugin.instance().getContext()});
            fileObjects = (Collection)ReflectUtil.method((Object)arguments, (String)"getFileObjects", (Class[])new Class[0]).invoke(new Object[0]);
        }
        for (JavaFileObject srcFile : fileObjects) {
            File file = new File(srcFile.getName());
            if (!file.getName().equals("BuildConfig.java")) continue;
            return this.extractBuildConfigSymbols(file);
        }
        return null;
    }

    private Map<String, String> extractBuildConfigSymbols(File buildConfig) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            List<JCTree> defs;
            Tree cls;
            CompilationUnitTree tree;
            java.util.List<? extends Tree> typeDecls;
            FileReader fileReader = new FileReader(buildConfig);
            ArrayList trees = new ArrayList();
            JavacPlugin.instance().getHost().getJavaParser().parseText(StreamUtil.getContent((Reader)fileReader), trees, null, null, null);
            if (!trees.isEmpty() && (typeDecls = (tree = (CompilationUnitTree)trees.get(0)).getTypeDecls()) != null && !typeDecls.isEmpty() && (cls = typeDecls.get(0)) instanceof JCTree.JCClassDecl && !(defs = ((JCTree.JCClassDecl)cls).defs).isEmpty()) {
                for (JCTree def : defs) {
                    if (!(def instanceof JCTree.JCVariableDecl)) continue;
                    this.processConstant(map, (JCTree.JCVariableDecl)def);
                }
            }
        }
        catch (IOException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
        return map;
    }

    private void processConstant(Map<String, String> map, JCTree.JCVariableDecl def) {
        JCTree.JCExpression initializer;
        int psf;
        JCTree.JCModifiers modifiers = def.getModifiers();
        long mods = modifiers == null ? 0L : modifiers.flags;
        if ((mods & (long)(psf = 25)) == (long)psf && (initializer = def.getInitializer()) != null) {
            String value;
            block8: {
                value = null;
                String init = initializer.toString();
                if (init.startsWith("\"")) {
                    value = init.substring(1, init.length() - 1);
                } else {
                    try {
                        long l = Long.parseLong(init);
                        value = init;
                    }
                    catch (Exception e) {
                        try {
                            double d = Double.parseDouble(init);
                            value = init;
                        }
                        catch (Exception e2) {
                            if (!init.contains("true")) break block8;
                            value = "";
                        }
                    }
                }
            }
            if (value != null) {
                map.put(def.getName().toString(), value);
            }
        }
    }

    private Map<String, String> loadBuildConfigSymbols_Class() {
        Class<?> buildConfigClass = this.loadBuildConfigClass();
        if (buildConfigClass == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        for (Field field : buildConfigClass.getDeclaredFields()) {
            int mods = field.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods)) continue;
            try {
                Object value = field.get(null);
                if (value == null) continue;
                symbols.put(field.getName(), String.valueOf(value));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access field: " + field.getName(), e);
            }
        }
        return symbols;
    }

    private Class<?> loadBuildConfigClass() {
        Path classesRoot = JavacPlugin.instance().getManifoldFileManager().getLocation(StandardLocation.CLASS_OUTPUT).iterator().next().toPath();
        try {
            Path classFile = Files.walk(classesRoot, new FileVisitOption[0]).filter(p -> p.getFileName().toString().equals("BuildConfig.class")).findFirst().orElse(null);
            if (classFile == null) {
                return null;
            }
            return new MyClassLoader().load(classesRoot, classFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MyClassLoader
    extends ClassLoader {
        MyClassLoader() {
            super(BuildConfigFinder.class.getClassLoader());
        }

        Class<?> load(Path classesRoot, Path classFile) throws IOException {
            String fqn = classesRoot.relativize(classFile).toString().replace(File.separatorChar, '.').replaceAll("\\.class$", "");
            byte[] bytes = Files.readAllBytes(classFile);
            return this.defineClass(fqn, bytes, 0, bytes.length);
        }
    }
}

