/*
 * Decompiled with CFR 0.152.
 */
package manifold.rt.api.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    private State _state = State.NotReady;
    private T _nextValue;

    protected abstract void computeNext();

    @Override
    public boolean hasNext() {
        switch (this._state) {
            case Done: {
                return false;
            }
            case Ready: {
                return true;
            }
            case Failed: {
                throw new IllegalStateException();
            }
        }
        return this.tryToComputeNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this._state = State.NotReady;
        return this._nextValue;
    }

    private boolean tryToComputeNext() {
        this._state = State.Failed;
        this.computeNext();
        return this._state == State.Ready;
    }

    protected void setNext(T value) {
        this._nextValue = value;
        this._state = State.Ready;
    }

    protected void done() {
        this._state = State.Done;
    }

    static enum State {
        Ready,
        NotReady,
        Done,
        Failed;

    }
}

