/*
 * Decompiled with CFR 0.152.
 */
package manifold.rt.api.util;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class ServiceUtil {
    public static <C> Set<C> loadRegisteredServices(Set<C> services, Class<C> serviceClass, ClassLoader classLoader) {
        C service2;
        ServiceLoader<C> loader = ServiceLoader.load(serviceClass);
        ServiceUtil.hackServiceLoaderToHandleProxyFactoryForJpms(loader, serviceClass, null);
        Iterator<C> iterator = loader.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                try {
                    service2 = iterator.next();
                    services.add(service2);
                }
                catch (ServiceConfigurationError service2) {}
            }
        }
        if (Thread.currentThread().getContextClassLoader() != classLoader) {
            loader = ServiceLoader.load(serviceClass, classLoader);
            ServiceUtil.hackServiceLoaderToHandleProxyFactoryForJpms(loader, serviceClass, classLoader);
            iterator = loader.iterator();
            while (iterator.hasNext()) {
                try {
                    service2 = iterator.next();
                    if (!ServiceUtil.isAbsent(services, service2)) continue;
                    services.add(service2);
                }
                catch (ServiceConfigurationError serviceConfigurationError) {}
            }
        }
        return services;
    }

    private static <C> void hackServiceLoaderToHandleProxyFactoryForJpms(ServiceLoader<C> serviceLoader, Class<?> serviceClass, ClassLoader classLoader) {
        if (!JreUtil.isJava9Modular_runtime() || !serviceClass.getSimpleName().equals("IProxyFactory_gen")) {
            return;
        }
        ReflectUtil.field(serviceLoader, (String)"lookupIterator1").set(ReflectUtil.constructor((String)"manifold.util.LazyClassPathLookupIterator", (Class[])new Class[]{Class.class, ClassLoader.class}).newInstance(new Object[]{serviceClass, classLoader == null ? ReflectUtil.field(serviceLoader, (String)"loader").get() : classLoader}));
    }

    static <C> boolean isAbsent(Set<C> services, C service) {
        for (C existingSp : services) {
            if (!existingSp.getClass().equals(service.getClass())) continue;
            return false;
        }
        return true;
    }
}

