/*
 * Copyright (c) 2020 - Manifold Systems LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package manifold.rt.api;

/**
 * Use this annotation to disable string template processing if you need to use the {@code '$'} literally within string
 * literals in your code. Read more about <a href="https://github.com/manifold-systems/manifold/tree/master/manifold-deps-parent/manifold-strings#bypassing-string-template-processing">bypassing string template processing</a>.
 * <p/>
 * Note this class resides outside the <i>manifold-strings</i> module to facilitate Maven's {@code optional} treatment,
 * which allows, say the {@code manifold-json} module, to hide its dependency on {@code manifold-strings} from modules
 * depending on it. The idea is that although {@code manifold-json} uses string templates, that doesn't mean modules
 * using JSON necessarily want string templates. Otherwise existing usage of {@code '$'} in the dependent module could
 * cause unwanted behavior. Thus, residing outside the {@code manifold-strings} module the {@code DisableStringLiteralTemplates}
 * annotation can be used in code generated by {@code manifold-json} with or without {@code manifold-strings} in scope
 * in the module depending on {@code manifold-json}.
 */
public @interface DisableStringLiteralTemplates
{
  boolean value() default true;
}
