/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractPrimaryUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.CapacitanceUnit;
import manifold.science.measures.Charge;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.PotentialUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class ChargeUnit
extends AbstractPrimaryUnit<Charge, ChargeUnit> {
    private static final UnitCache<ChargeUnit> CACHE = new UnitCache();
    public static final ChargeUnit Coulomb = ChargeUnit.get(CoercionConstants.r.postfixBind(1), "Coulomb", "C");
    public static final ChargeUnit Elementary = ChargeUnit.get(CoercionConstants.r.postfixBind("1.6021766208e-19"), "Elementary", "e");
    public static final ChargeUnit BASE = Coulomb;

    public static ChargeUnit get(Rational coulombs, String name, String symbol) {
        return (ChargeUnit)CACHE.get(new ChargeUnit(coulombs, name, symbol));
    }

    public ChargeUnit(Rational coulombs, String name, String symbol) {
        super(coulombs, name, symbol);
    }

    public Rational getCoulombs() {
        return this.toNumber();
    }

    @Override
    public Charge makeDimension(Number amount) {
        return new Charge(Rational.get(amount), this);
    }

    public CurrentUnit div(TimeUnit time) {
        return CurrentUnit.get(this, time);
    }

    public TimeUnit div(CurrentUnit i) {
        return i.getTimeUnit();
    }

    public CapacitanceUnit div(PotentialUnit p) {
        return CapacitanceUnit.get(this, p);
    }

    public PotentialUnit div(CapacitanceUnit cu) {
        return cu.getPotentialUnit();
    }
}

