/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Charge;
import manifold.science.measures.ChargeUnit;
import manifold.science.measures.Conductance;
import manifold.science.measures.ConductanceUnit;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.Potential;
import manifold.science.measures.PotentialUnit;
import manifold.science.measures.Time;
import manifold.science.util.Rational;

public final class Current
extends AbstractMeasure<CurrentUnit, Current> {
    public Current(Rational value, CurrentUnit unit, CurrentUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Current(Rational value, CurrentUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public CurrentUnit getBaseUnit() {
        return CurrentUnit.BASE;
    }

    @Override
    public Current make(Rational value, CurrentUnit unit, CurrentUnit displayUnit) {
        return new Current(value, unit, displayUnit);
    }

    @Override
    public Current make(Rational value, CurrentUnit unit) {
        return new Current(value, unit);
    }

    public Charge times(Time time) {
        return new Charge(this.toBaseNumber().times(time.toBaseNumber()), ChargeUnit.Coulomb);
    }

    public Conductance div(Potential p) {
        return new Conductance(this.toBaseNumber().div(p.toBaseNumber()), ConductanceUnit.BASE, ConductanceUnit.get((CurrentUnit)this.getDisplayUnit(), (PotentialUnit)p.getDisplayUnit()));
    }

    public Potential div(Conductance c) {
        return new Potential(this.toBaseNumber().div(c.toBaseNumber()), PotentialUnit.BASE, ((ConductanceUnit)c.getDisplayUnit()).getPotentialUnit());
    }
}

