/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.measures.DimensionlessUnit;
import manifold.science.util.MetricFactorConstants;
import manifold.science.util.Rational;

public enum MetricScaleUnit implements DimensionlessUnit
{
    y(MetricFactorConstants.YOCTO, "yocto", "y"),
    z(MetricFactorConstants.ZEPTO, "zepto", "z"),
    a(MetricFactorConstants.ATTO, "atto", "a"),
    fe(MetricFactorConstants.FEMTO, "femto", "f"),
    p(MetricFactorConstants.PICO, "pico", "p"),
    n(MetricFactorConstants.NANO, "nano", "n"),
    u(MetricFactorConstants.MICRO, "micro", "u"),
    m(MetricFactorConstants.MILLI, "milli", "m"),
    c(MetricFactorConstants.CENTI, "centi", "c"),
    de(MetricFactorConstants.DECI, "deci", "d"),
    da(MetricFactorConstants.DECA, "Deca", "da"),
    h(MetricFactorConstants.HECTO, "Hecto", "h"),
    k(MetricFactorConstants.KILO, "Kilo", "k"),
    Ki(MetricFactorConstants.KIBI, "Kibi", "Ki"),
    M(MetricFactorConstants.KILO.pow(2), "Mega", "M"),
    Mi(MetricFactorConstants.KIBI.pow(2), "Mebi", "Mi"),
    G(MetricFactorConstants.KILO.pow(3), "Giga", "G"),
    Gi(MetricFactorConstants.KIBI.pow(3), "Gibi", "Gi"),
    T(MetricFactorConstants.KILO.pow(4), "Tera", "T"),
    Ti(MetricFactorConstants.KIBI.pow(4), "Tebi", "Ti"),
    P(MetricFactorConstants.KILO.pow(5), "Peta", "P"),
    Pi(MetricFactorConstants.KIBI.pow(5), "Pebi", "Pi"),
    E(MetricFactorConstants.KILO.pow(6), "Exa", "E"),
    Ei(MetricFactorConstants.KIBI.pow(6), "Exbi", "Ei"),
    Z(MetricFactorConstants.KILO.pow(7), "Zetta", "Z"),
    Zi(MetricFactorConstants.KIBI.pow(7), "Zebi", "Zi"),
    Y(MetricFactorConstants.KILO.pow(8), "Yotta", "Y"),
    Yi(MetricFactorConstants.KIBI.pow(8), "Yobi", "Yi");

    private final Rational _amount;
    private final String _name;
    private final String _symbol;

    private MetricScaleUnit(Rational amount, String name, String symbol) {
        this._amount = amount;
        this._name = name;
        this._symbol = symbol;
    }

    @Override
    public Rational getAmount() {
        return this._amount;
    }

    @Override
    public String getUnitName() {
        return this._name;
    }

    @Override
    public String getUnitSymbol() {
        return this._symbol;
    }
}

