/*
 * Decompiled with CFR 0.152.
 */
package org.zenplex.tambora.papinet.V2R10;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.zenplex.tambora.papinet.V2R10.BusinessAcknowledgementDate;
import org.zenplex.tambora.papinet.V2R10.Document;
import org.zenplex.tambora.papinet.V2R10.Error;
import org.zenplex.tambora.papinet.V2R10.ReceiverParty;
import org.zenplex.tambora.papinet.V2R10.SenderParty;
import org.zenplex.tambora.papinet.V2R10.types.LanguageType;
import org.zenplex.tambora.papinet.V2R10.types.SuccessFailure;

public class BusinessAcknowledgement
implements Serializable {
    private SuccessFailure _status;
    private LanguageType _language = LanguageType.valueOf("eng");
    private String _businessAcknowledgementNumber;
    private BusinessAcknowledgementDate _businessAcknowledgementDate;
    private Document _document;
    private int _transactionHistoryNumber;
    private boolean _has_transactionHistoryNumber;
    private ArrayList _errorList;
    private SenderParty _senderParty;
    private ArrayList _receiverPartyList;

    public BusinessAcknowledgement() {
        this.setLanguage(LanguageType.valueOf("eng"));
        this._errorList = new ArrayList();
        this._receiverPartyList = new ArrayList();
    }

    public void addError(Error error) throws IndexOutOfBoundsException {
        this._errorList.add(error);
    }

    public void addError(int n, Error error) throws IndexOutOfBoundsException {
        this._errorList.add(n, error);
    }

    public void addReceiverParty(ReceiverParty receiverParty) throws IndexOutOfBoundsException {
        this._receiverPartyList.add(receiverParty);
    }

    public void addReceiverParty(int n, ReceiverParty receiverParty) throws IndexOutOfBoundsException {
        this._receiverPartyList.add(n, receiverParty);
    }

    public void clearError() {
        this._errorList.clear();
    }

    public void clearReceiverParty() {
        this._receiverPartyList.clear();
    }

    public void deleteTransactionHistoryNumber() {
        this._has_transactionHistoryNumber = false;
    }

    public Enumeration enumerateError() {
        return new IteratorEnumeration(((AbstractList)this._errorList).iterator());
    }

    public Enumeration enumerateReceiverParty() {
        return new IteratorEnumeration(((AbstractList)this._receiverPartyList).iterator());
    }

    public BusinessAcknowledgementDate getBusinessAcknowledgementDate() {
        return this._businessAcknowledgementDate;
    }

    public String getBusinessAcknowledgementNumber() {
        return this._businessAcknowledgementNumber;
    }

    public Document getDocument() {
        return this._document;
    }

    public Error getError(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._errorList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Error)this._errorList.get(n);
    }

    public Error[] getError() {
        int n = this._errorList.size();
        Error[] errorArray = new Error[n];
        int n2 = 0;
        while (n2 < n) {
            errorArray[n2] = (Error)this._errorList.get(n2);
            ++n2;
        }
        return errorArray;
    }

    public int getErrorCount() {
        return this._errorList.size();
    }

    public LanguageType getLanguage() {
        return this._language;
    }

    public ReceiverParty getReceiverParty(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._receiverPartyList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (ReceiverParty)this._receiverPartyList.get(n);
    }

    public ReceiverParty[] getReceiverParty() {
        int n = this._receiverPartyList.size();
        ReceiverParty[] receiverPartyArray = new ReceiverParty[n];
        int n2 = 0;
        while (n2 < n) {
            receiverPartyArray[n2] = (ReceiverParty)this._receiverPartyList.get(n2);
            ++n2;
        }
        return receiverPartyArray;
    }

    public int getReceiverPartyCount() {
        return this._receiverPartyList.size();
    }

    public SenderParty getSenderParty() {
        return this._senderParty;
    }

    public SuccessFailure getStatus() {
        return this._status;
    }

    public int getTransactionHistoryNumber() {
        return this._transactionHistoryNumber;
    }

    public boolean hasTransactionHistoryNumber() {
        return this._has_transactionHistoryNumber;
    }

    public boolean removeError(Error error) {
        boolean bl = ((AbstractCollection)this._errorList).remove(error);
        return bl;
    }

    public boolean removeReceiverParty(ReceiverParty receiverParty) {
        boolean bl = ((AbstractCollection)this._receiverPartyList).remove(receiverParty);
        return bl;
    }

    public void setBusinessAcknowledgementDate(BusinessAcknowledgementDate businessAcknowledgementDate) {
        this._businessAcknowledgementDate = businessAcknowledgementDate;
    }

    public void setBusinessAcknowledgementNumber(String string) {
        this._businessAcknowledgementNumber = string;
    }

    public void setDocument(Document document) {
        this._document = document;
    }

    public void setError(int n, Error error) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._errorList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._errorList.set(n, error);
    }

    public void setError(Error[] errorArray) {
        this._errorList.clear();
        int n = 0;
        while (n < errorArray.length) {
            this._errorList.add(errorArray[n]);
            ++n;
        }
    }

    public void setLanguage(LanguageType languageType) {
        this._language = languageType;
    }

    public void setReceiverParty(int n, ReceiverParty receiverParty) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._receiverPartyList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._receiverPartyList.set(n, receiverParty);
    }

    public void setReceiverParty(ReceiverParty[] receiverPartyArray) {
        this._receiverPartyList.clear();
        int n = 0;
        while (n < receiverPartyArray.length) {
            this._receiverPartyList.add(receiverPartyArray[n]);
            ++n;
        }
    }

    public void setSenderParty(SenderParty senderParty) {
        this._senderParty = senderParty;
    }

    public void setStatus(SuccessFailure successFailure) {
        this._status = successFailure;
    }

    public void setTransactionHistoryNumber(int n) {
        this._transactionHistoryNumber = n;
        this._has_transactionHistoryNumber = true;
    }
}

