/*
 * Decompiled with CFR 0.152.
 */
package org.zenplex.tambora.papinet.V2R10;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.zenplex.tambora.papinet.V2R10.ComplaintHeader;
import org.zenplex.tambora.papinet.V2R10.ComplaintLineItem;
import org.zenplex.tambora.papinet.V2R10.ComplaintSummary;
import org.zenplex.tambora.papinet.V2R10.types.ComplaintType;
import org.zenplex.tambora.papinet.V2R10.types.LanguageType;
import org.zenplex.tambora.papinet.V2R10.types.YesNo;

public class Complaint
implements Serializable {
    private ComplaintType _complaintType;
    private YesNo _reissued = YesNo.valueOf("No");
    private LanguageType _language = LanguageType.valueOf("eng");
    private ComplaintHeader _complaintHeader;
    private ArrayList _complaintLineItemList;
    private ComplaintSummary _complaintSummary;

    public Complaint() {
        this.setReissued(YesNo.valueOf("No"));
        this.setLanguage(LanguageType.valueOf("eng"));
        this._complaintLineItemList = new ArrayList();
    }

    public void addComplaintLineItem(ComplaintLineItem complaintLineItem) throws IndexOutOfBoundsException {
        this._complaintLineItemList.add(complaintLineItem);
    }

    public void addComplaintLineItem(int n, ComplaintLineItem complaintLineItem) throws IndexOutOfBoundsException {
        this._complaintLineItemList.add(n, complaintLineItem);
    }

    public void clearComplaintLineItem() {
        this._complaintLineItemList.clear();
    }

    public Enumeration enumerateComplaintLineItem() {
        return new IteratorEnumeration(((AbstractList)this._complaintLineItemList).iterator());
    }

    public ComplaintHeader getComplaintHeader() {
        return this._complaintHeader;
    }

    public ComplaintLineItem getComplaintLineItem(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._complaintLineItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (ComplaintLineItem)this._complaintLineItemList.get(n);
    }

    public ComplaintLineItem[] getComplaintLineItem() {
        int n = this._complaintLineItemList.size();
        ComplaintLineItem[] complaintLineItemArray = new ComplaintLineItem[n];
        int n2 = 0;
        while (n2 < n) {
            complaintLineItemArray[n2] = (ComplaintLineItem)this._complaintLineItemList.get(n2);
            ++n2;
        }
        return complaintLineItemArray;
    }

    public int getComplaintLineItemCount() {
        return this._complaintLineItemList.size();
    }

    public ComplaintSummary getComplaintSummary() {
        return this._complaintSummary;
    }

    public ComplaintType getComplaintType() {
        return this._complaintType;
    }

    public LanguageType getLanguage() {
        return this._language;
    }

    public YesNo getReissued() {
        return this._reissued;
    }

    public boolean removeComplaintLineItem(ComplaintLineItem complaintLineItem) {
        boolean bl = ((AbstractCollection)this._complaintLineItemList).remove(complaintLineItem);
        return bl;
    }

    public void setComplaintHeader(ComplaintHeader complaintHeader) {
        this._complaintHeader = complaintHeader;
    }

    public void setComplaintLineItem(int n, ComplaintLineItem complaintLineItem) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._complaintLineItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._complaintLineItemList.set(n, complaintLineItem);
    }

    public void setComplaintLineItem(ComplaintLineItem[] complaintLineItemArray) {
        this._complaintLineItemList.clear();
        int n = 0;
        while (n < complaintLineItemArray.length) {
            this._complaintLineItemList.add(complaintLineItemArray[n]);
            ++n;
        }
    }

    public void setComplaintSummary(ComplaintSummary complaintSummary) {
        this._complaintSummary = complaintSummary;
    }

    public void setComplaintType(ComplaintType complaintType) {
        this._complaintType = complaintType;
    }

    public void setLanguage(LanguageType languageType) {
        this._language = languageType;
    }

    public void setReissued(YesNo yesNo) {
        this._reissued = yesNo;
    }
}

