/*
 * Decompiled with CFR 0.152.
 */
package org.zenplex.tambora.papinet.V2R10;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.zenplex.tambora.papinet.V2R10.InvoiceHeader;
import org.zenplex.tambora.papinet.V2R10.InvoiceLineItem;
import org.zenplex.tambora.papinet.V2R10.InvoiceSummary;
import org.zenplex.tambora.papinet.V2R10.MonetaryAdjustment;
import org.zenplex.tambora.papinet.V2R10.types.InvoiceType;
import org.zenplex.tambora.papinet.V2R10.types.LanguageType;
import org.zenplex.tambora.papinet.V2R10.types.YesNo;

public class Invoice
implements Serializable {
    private InvoiceType _invoiceType;
    private YesNo _reissued = YesNo.valueOf("No");
    private LanguageType _language = LanguageType.valueOf("eng");
    private InvoiceHeader _invoiceHeader;
    private ArrayList _invoiceLineItemList;
    private ArrayList _monetaryAdjustmentList;
    private InvoiceSummary _invoiceSummary;

    public Invoice() {
        this.setReissued(YesNo.valueOf("No"));
        this.setLanguage(LanguageType.valueOf("eng"));
        this._invoiceLineItemList = new ArrayList();
        this._monetaryAdjustmentList = new ArrayList();
    }

    public void addInvoiceLineItem(InvoiceLineItem invoiceLineItem) throws IndexOutOfBoundsException {
        this._invoiceLineItemList.add(invoiceLineItem);
    }

    public void addInvoiceLineItem(int n, InvoiceLineItem invoiceLineItem) throws IndexOutOfBoundsException {
        this._invoiceLineItemList.add(n, invoiceLineItem);
    }

    public void addMonetaryAdjustment(MonetaryAdjustment monetaryAdjustment) throws IndexOutOfBoundsException {
        this._monetaryAdjustmentList.add(monetaryAdjustment);
    }

    public void addMonetaryAdjustment(int n, MonetaryAdjustment monetaryAdjustment) throws IndexOutOfBoundsException {
        this._monetaryAdjustmentList.add(n, monetaryAdjustment);
    }

    public void clearInvoiceLineItem() {
        this._invoiceLineItemList.clear();
    }

    public void clearMonetaryAdjustment() {
        this._monetaryAdjustmentList.clear();
    }

    public Enumeration enumerateInvoiceLineItem() {
        return new IteratorEnumeration(((AbstractList)this._invoiceLineItemList).iterator());
    }

    public Enumeration enumerateMonetaryAdjustment() {
        return new IteratorEnumeration(((AbstractList)this._monetaryAdjustmentList).iterator());
    }

    public InvoiceHeader getInvoiceHeader() {
        return this._invoiceHeader;
    }

    public InvoiceLineItem getInvoiceLineItem(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._invoiceLineItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (InvoiceLineItem)this._invoiceLineItemList.get(n);
    }

    public InvoiceLineItem[] getInvoiceLineItem() {
        int n = this._invoiceLineItemList.size();
        InvoiceLineItem[] invoiceLineItemArray = new InvoiceLineItem[n];
        int n2 = 0;
        while (n2 < n) {
            invoiceLineItemArray[n2] = (InvoiceLineItem)this._invoiceLineItemList.get(n2);
            ++n2;
        }
        return invoiceLineItemArray;
    }

    public int getInvoiceLineItemCount() {
        return this._invoiceLineItemList.size();
    }

    public InvoiceSummary getInvoiceSummary() {
        return this._invoiceSummary;
    }

    public InvoiceType getInvoiceType() {
        return this._invoiceType;
    }

    public LanguageType getLanguage() {
        return this._language;
    }

    public MonetaryAdjustment getMonetaryAdjustment(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._monetaryAdjustmentList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (MonetaryAdjustment)this._monetaryAdjustmentList.get(n);
    }

    public MonetaryAdjustment[] getMonetaryAdjustment() {
        int n = this._monetaryAdjustmentList.size();
        MonetaryAdjustment[] monetaryAdjustmentArray = new MonetaryAdjustment[n];
        int n2 = 0;
        while (n2 < n) {
            monetaryAdjustmentArray[n2] = (MonetaryAdjustment)this._monetaryAdjustmentList.get(n2);
            ++n2;
        }
        return monetaryAdjustmentArray;
    }

    public int getMonetaryAdjustmentCount() {
        return this._monetaryAdjustmentList.size();
    }

    public YesNo getReissued() {
        return this._reissued;
    }

    public boolean removeInvoiceLineItem(InvoiceLineItem invoiceLineItem) {
        boolean bl = ((AbstractCollection)this._invoiceLineItemList).remove(invoiceLineItem);
        return bl;
    }

    public boolean removeMonetaryAdjustment(MonetaryAdjustment monetaryAdjustment) {
        boolean bl = ((AbstractCollection)this._monetaryAdjustmentList).remove(monetaryAdjustment);
        return bl;
    }

    public void setInvoiceHeader(InvoiceHeader invoiceHeader) {
        this._invoiceHeader = invoiceHeader;
    }

    public void setInvoiceLineItem(int n, InvoiceLineItem invoiceLineItem) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._invoiceLineItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._invoiceLineItemList.set(n, invoiceLineItem);
    }

    public void setInvoiceLineItem(InvoiceLineItem[] invoiceLineItemArray) {
        this._invoiceLineItemList.clear();
        int n = 0;
        while (n < invoiceLineItemArray.length) {
            this._invoiceLineItemList.add(invoiceLineItemArray[n]);
            ++n;
        }
    }

    public void setInvoiceSummary(InvoiceSummary invoiceSummary) {
        this._invoiceSummary = invoiceSummary;
    }

    public void setInvoiceType(InvoiceType invoiceType) {
        this._invoiceType = invoiceType;
    }

    public void setLanguage(LanguageType languageType) {
        this._language = languageType;
    }

    public void setMonetaryAdjustment(int n, MonetaryAdjustment monetaryAdjustment) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._monetaryAdjustmentList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._monetaryAdjustmentList.set(n, monetaryAdjustment);
    }

    public void setMonetaryAdjustment(MonetaryAdjustment[] monetaryAdjustmentArray) {
        this._monetaryAdjustmentList.clear();
        int n = 0;
        while (n < monetaryAdjustmentArray.length) {
            this._monetaryAdjustmentList.add(monetaryAdjustmentArray[n]);
            ++n;
        }
    }

    public void setReissued(YesNo yesNo) {
        this._reissued = yesNo;
    }
}

