/*
 * Decompiled with CFR 0.152.
 */
package org.zenplex.tambora.papinet.V2R10;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.zenplex.tambora.papinet.V2R10.RFQHeader;
import org.zenplex.tambora.papinet.V2R10.RFQLineItem;
import org.zenplex.tambora.papinet.V2R10.RFQSummary;
import org.zenplex.tambora.papinet.V2R10.types.LanguageType;
import org.zenplex.tambora.papinet.V2R10.types.RFQRFQStatusTypeType;
import org.zenplex.tambora.papinet.V2R10.types.RfqType;

public class RFQ
implements Serializable {
    private RfqType _RFQType;
    private RFQRFQStatusTypeType _RFQStatusType;
    private LanguageType _language = LanguageType.valueOf("eng");
    private RFQHeader _RFQHeader;
    private ArrayList _RFQLineItemList;
    private RFQSummary _RFQSummary;

    public RFQ() {
        this.setLanguage(LanguageType.valueOf("eng"));
        this._RFQLineItemList = new ArrayList();
    }

    public void addRFQLineItem(RFQLineItem rFQLineItem) throws IndexOutOfBoundsException {
        this._RFQLineItemList.add(rFQLineItem);
    }

    public void addRFQLineItem(int n, RFQLineItem rFQLineItem) throws IndexOutOfBoundsException {
        this._RFQLineItemList.add(n, rFQLineItem);
    }

    public void clearRFQLineItem() {
        this._RFQLineItemList.clear();
    }

    public Enumeration enumerateRFQLineItem() {
        return new IteratorEnumeration(((AbstractList)this._RFQLineItemList).iterator());
    }

    public LanguageType getLanguage() {
        return this._language;
    }

    public RFQHeader getRFQHeader() {
        return this._RFQHeader;
    }

    public RFQLineItem getRFQLineItem(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._RFQLineItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (RFQLineItem)this._RFQLineItemList.get(n);
    }

    public RFQLineItem[] getRFQLineItem() {
        int n = this._RFQLineItemList.size();
        RFQLineItem[] rFQLineItemArray = new RFQLineItem[n];
        int n2 = 0;
        while (n2 < n) {
            rFQLineItemArray[n2] = (RFQLineItem)this._RFQLineItemList.get(n2);
            ++n2;
        }
        return rFQLineItemArray;
    }

    public int getRFQLineItemCount() {
        return this._RFQLineItemList.size();
    }

    public RFQRFQStatusTypeType getRFQStatusType() {
        return this._RFQStatusType;
    }

    public RFQSummary getRFQSummary() {
        return this._RFQSummary;
    }

    public RfqType getRFQType() {
        return this._RFQType;
    }

    public boolean removeRFQLineItem(RFQLineItem rFQLineItem) {
        boolean bl = ((AbstractCollection)this._RFQLineItemList).remove(rFQLineItem);
        return bl;
    }

    public void setLanguage(LanguageType languageType) {
        this._language = languageType;
    }

    public void setRFQHeader(RFQHeader rFQHeader) {
        this._RFQHeader = rFQHeader;
    }

    public void setRFQLineItem(int n, RFQLineItem rFQLineItem) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._RFQLineItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._RFQLineItemList.set(n, rFQLineItem);
    }

    public void setRFQLineItem(RFQLineItem[] rFQLineItemArray) {
        this._RFQLineItemList.clear();
        int n = 0;
        while (n < rFQLineItemArray.length) {
            this._RFQLineItemList.add(rFQLineItemArray[n]);
            ++n;
        }
    }

    public void setRFQStatusType(RFQRFQStatusTypeType rFQRFQStatusTypeType) {
        this._RFQStatusType = rFQRFQStatusTypeType;
    }

    public void setRFQSummary(RFQSummary rFQSummary) {
        this._RFQSummary = rFQSummary;
    }

    public void setRFQType(RfqType rfqType) {
        this._RFQType = rfqType;
    }
}

