/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.test.Main;
import org.tanukisoftware.wrapper.test.RuntimeExec;

public class ExecParallel {
    private static String CMD;
    private static String EXECUTABLE;
    private static final int CHILD_SLEEP_TIME_S = 4;
    private static final long CHILD_SLEEP_TIME_MS = 4000L;
    private static String[] testIds;
    private static long[] totalSysTime;
    private static int seriesIndex;

    private static void doTestInner(String command, String testId, boolean newProcessGroup) {
        WrapperProcessConfig wrapperProcessConfig = new WrapperProcessConfig().setNewProcessGroup(newProcessGroup);
        try {
            RuntimeExec.handleWrapperProcess(testId, command, wrapperProcessConfig, 0L, false, false, false, 1, 0, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void doTest(String testId, boolean newProcessGroup, boolean useCmd, boolean detached) {
        if (!useCmd) {
            ExecParallel.doTestInner(EXECUTABLE + " 0 " + 4, testId, newProcessGroup);
        } else if (!detached) {
            if (WrapperManager.isWindows()) {
                ExecParallel.doTestInner("cmd /c \"" + EXECUTABLE + " 0 " + 4 + "\"", testId, newProcessGroup);
            } else {
                ExecParallel.doTestInner("bash -c \"" + EXECUTABLE + " 0 " + 4 + "\"", testId, newProcessGroup);
            }
        } else if (WrapperManager.isWindows()) {
            ExecParallel.doTestInner("cmd /c \"start /B " + EXECUTABLE + " 0 " + 4 + "\"", testId, newProcessGroup);
        } else {
            ExecParallel.doTestInner("bash -c \"" + EXECUTABLE + " 0 " + 4 + " &\"", testId, newProcessGroup);
        }
    }

    private static void doTestsParallel(final boolean newProcessGroup, final boolean useCmd, final boolean detached) {
        long expectedTime;
        String testIdBase = newProcessGroup ? "NewProcessGroup|" : "";
        if (!useCmd) {
            testIdBase = testIdBase + "simplewaiter ";
            expectedTime = 4000L;
        } else if (!detached) {
            testIdBase = testIdBase + CMD + "+simplewaiter ";
            expectedTime = 4000L;
        } else {
            testIdBase = testIdBase + CMD + "+simplewaiter(detached) ";
            expectedTime = newProcessGroup ? 4000L : 0L;
        }
        for (int i = 0; i < 10; i += 2) {
            int j;
            int n = (int)Math.pow(2.0, i);
            final String testId = testIdBase + "(" + n + " threads) :";
            RuntimeExec.beginCase(testId);
            Thread[] threads = new Thread[n];
            for (int j2 = 0; j2 < n; ++j2) {
                threads[j2] = new Thread(){

                    public void run() {
                        ExecParallel.doTest(testId, newProcessGroup, useCmd, detached);
                    }
                };
            }
            long sysTime = System.currentTimeMillis();
            for (j = 0; j < n; ++j) {
                threads[j].start();
            }
            for (j = 0; j < n; ++j) {
                try {
                    threads[j].join();
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            sysTime = System.currentTimeMillis() - sysTime;
            RuntimeExec.endCase(testId + " (System time: " + sysTime + "ms)", expectedTime);
            int n2 = seriesIndex;
            totalSysTime[n2] = totalSysTime[n2] + sysTime;
        }
        ExecParallel.testIds[ExecParallel.seriesIndex] = testIdBase;
        ++seriesIndex;
    }

    public static void main(String[] args) {
        RuntimeExec.c_testsPerformed = 0;
        RuntimeExec.c_testsFailed = 0;
        System.out.println("");
        System.out.println(Main.getRes().getString("Running test with wrapper.child.wait_signals=" + System.getProperty("wrapper.child.wait_signals")));
        System.out.println(Main.getRes().getString("Running test with wrapper.child.wait_signals.max_threads=" + System.getProperty("wrapper.child.wait_signals.max_threads")));
        System.out.println(Main.getRes().getString(" You may change the values of these properties in the execparallel.conf."));
        ExecParallel.doTestsParallel(false, false, false);
        ExecParallel.doTestsParallel(false, true, false);
        ExecParallel.doTestsParallel(false, true, true);
        ExecParallel.doTestsParallel(true, false, false);
        ExecParallel.doTestsParallel(true, true, false);
        ExecParallel.doTestsParallel(true, true, true);
        int nbTestsFailed = RuntimeExec.c_testsFailed;
        int nbTestsPassed = RuntimeExec.c_testsPerformed - nbTestsFailed;
        System.out.println("");
        System.out.println(Main.getRes().getString("[PASSED] {0}", (Object)Integer.toString(nbTestsPassed)));
        System.out.println(Main.getRes().getString("[FAILED] {0}", (Object)Integer.toString(nbTestsFailed)));
        System.out.println(Main.getRes().getString("--------------------"));
        for (int i = 0; i < testIds.length; ++i) {
            System.out.println(Main.getRes().getString("{0}: System time: {1}ms", (Object)testIds[i], (Object)Long.toString(totalSysTime[i])));
        }
        System.out.println(Main.getRes().getString("--------------------"));
        if (nbTestsFailed > 0) {
            System.exit(1);
        }
    }

    static {
        testIds = new String[6];
        totalSysTime = new long[6];
        seriesIndex = 0;
        if (WrapperManager.isWindows()) {
            EXECUTABLE = "..\\test\\simplewaiter.exe";
            CMD = "CMD";
        } else {
            EXECUTABLE = "../test/simplewaiter";
            CMD = "Bash";
        }
    }
}

