/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tanukisoftware.wrapper.WrapperManager;

public class WrapperProcessInputStream
extends InputStream {
    private long m_ptr;
    private boolean m_closed;
    private ByteArrayInputStream m_bais;
    private boolean m_read;
    private volatile boolean m_terminated;
    private volatile boolean m_checkTerminated;
    private Object m_readSm = new Object();

    private WrapperProcessInputStream() {
    }

    private native int nativeRead(boolean var1);

    private native void nativeClose();

    private native int nativeRead2(byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        WrapperProcessInputStream wrapperProcessInputStream = this;
        synchronized (wrapperProcessInputStream) {
            if (!this.m_closed) {
                if (WrapperManager.isNativeLibraryOk()) {
                    this.nativeClose();
                }
                this.m_closed = true;
            }
        }
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() {
        WrapperProcessInputStream wrapperProcessInputStream = this;
        synchronized (wrapperProcessInputStream) {
            return !this.m_closed || this.m_bais != null && this.m_bais.available() > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object;
        if (!this.m_read) {
            object = this.m_readSm;
            synchronized (object) {
                this.m_read = true;
            }
        }
        object = this;
        synchronized (object) {
            if (!this.m_closed && WrapperManager.isNativeLibraryOk()) {
                return this.nativeRead(true);
            }
            if (this.m_bais != null) {
                return this.m_bais.read();
            }
            throw new IOException(WrapperManager.getRes().getString("Stream is closed."));
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int read(byte[] b, int off, int len) throws IOException {
        Object object;
        if (!this.m_read) {
            object = this.m_readSm;
            synchronized (object) {
                this.m_read = true;
            }
        }
        object = this;
        synchronized (object) {
            void var5_6;
            int result;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (!this.ready()) {
                return -1;
            }
            if (!this.m_closed && WrapperManager.isNativeLibraryOk()) {
                result = this.nativeRead2(b, off, len);
            } else if (this.m_bais != null) {
                result = this.m_bais.read(b, off, len);
            } else {
                throw new IOException(WrapperManager.getRes().getString("Stream is closed."));
            }
            return (int)var5_6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndCloseOpenFDs() {
        this.m_terminated = true;
        Object object = this.m_readSm;
        synchronized (object) {
            if (this.m_read) {
                return;
            }
        }
        object = this;
        synchronized (object) {
            if (this.m_closed || !WrapperManager.isNativeLibraryOk()) {
                return;
            }
            try {
                int msg;
                byte[] buffer = new byte[1024];
                int count = 0;
                while ((msg = this.nativeRead(false)) != -1) {
                    if (count >= buffer.length) {
                        byte[] temp = new byte[buffer.length + 1024];
                        System.arraycopy(buffer, 0, temp, 0, buffer.length);
                        buffer = temp;
                    }
                    buffer[count++] = (byte)msg;
                }
                this.m_bais = new ByteArrayInputStream(buffer, 0, count);
                this.close();
            }
            catch (IOException ioe) {
                System.out.println(WrapperManager.getRes().getString("WrapperProcessStream encountered a ReadError: "));
                ioe.printStackTrace();
            }
        }
    }
}

