/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.contrib.table.model.simple;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import net.sf.tapestry.contrib.table.model.CTableDataModelEvent;
import net.sf.tapestry.contrib.table.model.ITableColumn;
import net.sf.tapestry.contrib.table.model.ITableColumnModel;
import net.sf.tapestry.contrib.table.model.ITableDataModel;
import net.sf.tapestry.contrib.table.model.ITableDataModelListener;
import net.sf.tapestry.contrib.table.model.ITableModel;
import net.sf.tapestry.contrib.table.model.ITablePagingState;
import net.sf.tapestry.contrib.table.model.ITableSortingState;
import net.sf.tapestry.contrib.table.model.common.ArrayIterator;
import net.sf.tapestry.contrib.table.model.common.ReverseComparator;
import net.sf.tapestry.contrib.table.model.simple.SimpleListTableDataModel;
import net.sf.tapestry.contrib.table.model.simple.SimpleTableColumnModel;
import net.sf.tapestry.contrib.table.model.simple.SimpleTableSortingState;
import net.sf.tapestry.contrib.table.model.simple.SimpleTableState;

public class SimpleTableModel
implements ITableModel,
ITableDataModelListener,
Serializable {
    private ITableDataModel m_objDataModel;
    private Object[] m_arrRows = null;
    private ITableColumnModel m_objColumnModel;
    private SimpleTableState m_objState;
    private SimpleTableSortingState m_objLastSortingState;

    public SimpleTableModel(Object[] arrData, ITableColumn[] arrColumns) {
        this(new SimpleListTableDataModel(arrData), new SimpleTableColumnModel(arrColumns));
    }

    public SimpleTableModel(ITableDataModel objDataModel, ITableColumnModel objColumnModel) {
        this(objDataModel, objColumnModel, new SimpleTableState());
    }

    public SimpleTableModel(ITableDataModel objDataModel, ITableColumnModel objColumnModel, SimpleTableState objState) {
        this.m_objColumnModel = objColumnModel;
        this.m_objState = objState;
        this.m_objLastSortingState = new SimpleTableSortingState();
        this.m_objDataModel = objDataModel;
        this.m_objDataModel.addTableDataModelListener(this);
    }

    public SimpleTableState getState() {
        return this.m_objState;
    }

    public ITableColumnModel getColumnModel() {
        return this.m_objColumnModel;
    }

    public Iterator getCurrentPageRows() {
        this.sortRows();
        int nPageSize = this.getPagingState().getPageSize();
        int nCurrentPage = this.getPagingState().getCurrentPage();
        int nFrom = nCurrentPage * nPageSize;
        int nTo = (nCurrentPage + 1) * nPageSize;
        return new ArrayIterator(this.m_arrRows, nFrom, nTo);
    }

    public int getPageCount() {
        int nRowCount = this.getRowCount();
        if (nRowCount == 0) {
            return 1;
        }
        return (nRowCount - 1) / this.getPagingState().getPageSize() + 1;
    }

    public ITablePagingState getPagingState() {
        return this.m_objState.getPagingState();
    }

    public ITableSortingState getSortingState() {
        return this.m_objState.getSortingState();
    }

    public int getRowCount() {
        this.updateRows();
        return this.m_arrRows.length;
    }

    private void updateRows() {
        if (this.m_arrRows != null) {
            return;
        }
        this.m_objLastSortingState = new SimpleTableSortingState();
        int nRowCount = this.m_objDataModel.getRowCount();
        Object[] arrRows = new Object[nRowCount];
        int i = 0;
        Iterator it = this.m_objDataModel.getRows();
        while (it.hasNext()) {
            arrRows[i++] = it.next();
        }
        this.m_arrRows = arrRows;
    }

    protected void sortRows() {
        this.updateRows();
        ITableSortingState objSortingState = this.getSortingState();
        String strSortColumn = objSortingState.getSortColumn();
        if (strSortColumn == null) {
            return;
        }
        boolean bSortOrder = objSortingState.getSortOrder();
        if (strSortColumn.equals(this.m_objLastSortingState.getSortColumn()) && this.m_objLastSortingState.getSortOrder() == bSortOrder) {
            return;
        }
        ITableColumn objColumn = this.getColumnModel().getColumn(strSortColumn);
        if (objColumn == null || !objColumn.getSortable()) {
            return;
        }
        Comparator objCmp = objColumn.getComparator();
        if (objCmp == null) {
            return;
        }
        if (bSortOrder) {
            objCmp = new ReverseComparator(objCmp);
        }
        Arrays.sort(this.m_arrRows, objCmp);
        this.m_objLastSortingState.setSortColumn(strSortColumn, bSortOrder);
    }

    public void tableDataChanged(CTableDataModelEvent objEvent) {
        this.m_arrRows = null;
    }

    public ITableDataModel getDataModel() {
        return this.m_objDataModel;
    }

    public void setDataModel(ITableDataModel dataModel) {
        this.m_objDataModel = dataModel;
        this.m_arrRows = null;
    }
}

