/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IBeanProvider;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IComponentStrings;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.INamespace;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IPageLoader;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.NoSuchComponentException;
import net.sf.tapestry.PageLoaderException;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.bean.BeanProvider;
import net.sf.tapestry.bean.BeanProviderPropertyAccessor;
import net.sf.tapestry.event.ChangeObserver;
import net.sf.tapestry.event.ObservedChangeEvent;
import net.sf.tapestry.listener.ListenerMap;
import net.sf.tapestry.param.ParameterManager;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.spec.ContainedComponent;
import net.sf.tapestry.util.prop.OgnlUtils;
import net.sf.tapestry.util.prop.PropertyFinder;
import net.sf.tapestry.util.prop.PropertyInfo;
import net.sf.tapestry.util.prop.PublicBeanPropertyAccessor;
import ognl.ClassResolver;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;

public abstract class AbstractComponent
implements IComponent {
    protected ComponentSpecification specification;
    protected IPage page;
    private IComponent _container;
    protected String id;
    private String _idPath;
    private static final int MAP_SIZE = 5;
    private Map _bindings;
    private Map _components;
    private static final int WRAPPED_INIT_SIZE = 5;
    private INamespace _namespace;
    private static final Map EMPTY_MAP;
    protected int wrappedCount = 0;
    protected IRender[] wrapped;
    private Map _assets;
    private ListenerMap _listeners;
    private IBeanProvider _beans;
    private ParameterManager _parameterManager;
    private IComponentStrings _strings;
    static /* synthetic */ Class class$net$sf$tapestry$IBeanProvider;
    static /* synthetic */ Class class$net$sf$tapestry$util$prop$IPublicBean;
    static /* synthetic */ Class class$net$sf$tapestry$IBinding;

    public void addAsset(String name, IAsset asset) {
        if (this._assets == null) {
            this._assets = new HashMap(5);
        }
        this._assets.put(name, asset);
    }

    public void addComponent(IComponent component) {
        if (this._components == null) {
            this._components = new HashMap(5);
        }
        this._components.put(component.getId(), component);
    }

    public void addWrapped(IRender element) {
        this.addBody(element);
    }

    public void addBody(IRender element) {
        if (this.wrapped == null) {
            this.wrapped = new IRender[5];
            this.wrapped[0] = element;
            this.wrappedCount = 1;
            return;
        }
        if (this.wrappedCount == this.wrapped.length) {
            IRender[] newWrapped = new IRender[this.wrapped.length * 2];
            System.arraycopy(this.wrapped, 0, newWrapped, 0, this.wrappedCount);
            this.wrapped = newWrapped;
        }
        this.wrapped[this.wrappedCount++] = element;
    }

    public void finishLoad(IRequestCycle cycle, IPageLoader loader, ComponentSpecification specification) throws PageLoaderException {
        this.finishLoad();
    }

    protected void fireObservedChange(String propertyName, int newValue) {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent((IComponent)this, propertyName, newValue);
        observer.observeChange(event);
    }

    protected void fireObservedChange(String propertyName, Object newValue) {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent((IComponent)this, propertyName, newValue);
        observer.observeChange(event);
    }

    protected void fireObservedChange(String propertyName, boolean newValue) {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent((IComponent)this, propertyName, newValue);
        observer.observeChange(event);
    }

    protected void fireObservedChange(String propertyName, double newValue) {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent((IComponent)this, propertyName, newValue);
        observer.observeChange(event);
    }

    protected void fireObservedChange(String propertyName, float newValue) {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent((IComponent)this, propertyName, newValue);
        observer.observeChange(event);
    }

    protected void fireObservedChange(String propertyName, long newValue) {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent((IComponent)this, propertyName, newValue);
        observer.observeChange(event);
    }

    protected void fireObservedChange(String propertyName, char newValue) {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent((IComponent)this, propertyName, newValue);
        observer.observeChange(event);
    }

    protected void fireObservedChange(String propertyName, byte newValue) {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent((IComponent)this, propertyName, newValue);
        observer.observeChange(event);
    }

    protected void fireObservedChange(String propertyName, short newValue) {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent((IComponent)this, propertyName, newValue);
        observer.observeChange(event);
    }

    protected void fireObservedChange() {
        ChangeObserver observer = this.getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(this);
        observer.observeChange(event);
    }

    protected void generateAttributes(IMarkupWriter writer, IRequestCycle cycle) {
        if (this._bindings == null) {
            return;
        }
        Iterator i = this._bindings.entrySet().iterator();
        while (i.hasNext()) {
            String attribute;
            IBinding binding;
            Object value;
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            if (this.specification.getParameter(name) != null || (value = (binding = (IBinding)entry.getValue()).getObject()) == null) continue;
            if (value instanceof IAsset) {
                IAsset asset = (IAsset)value;
                attribute = asset.buildURL(cycle);
            } else {
                attribute = value.toString();
            }
            writer.attribute(name, attribute);
        }
    }

    public IBinding getBinding(String name) {
        String bindingPropertyName = name + "Binding";
        PropertyInfo info = PropertyFinder.getPropertyInfo(this.getClass(), bindingPropertyName);
        if (info != null && info.isReadWrite() && info.getType().equals(class$net$sf$tapestry$IBinding == null ? (class$net$sf$tapestry$IBinding = AbstractComponent.class$("net.sf.tapestry.IBinding")) : class$net$sf$tapestry$IBinding)) {
            IResourceResolver resolver = this.getPage().getEngine().getResourceResolver();
            return (IBinding)OgnlUtils.get(bindingPropertyName, (ClassResolver)resolver, (Object)this);
        }
        if (this._bindings == null) {
            return null;
        }
        return (IBinding)this._bindings.get(name);
    }

    public ChangeObserver getChangeObserver() {
        return this.page.getChangeObserver();
    }

    public IComponent getComponent(String id) {
        IComponent result = null;
        if (this._components != null) {
            result = (IComponent)this._components.get(id);
        }
        if (result == null) {
            throw new NoSuchComponentException(id, this);
        }
        return result;
    }

    public IComponent getContainer() {
        return this._container;
    }

    public void setContainer(IComponent value) {
        if (this._container != null) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractComponent.attempt-to-change-container"));
        }
        this._container = value;
    }

    public String getExtendedId() {
        if (this.page == null) {
            return null;
        }
        return this.page.getName() + "/" + this.getIdPath();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.id != null) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractComponent.attempt-to-change-component-id"));
        }
        this.id = value;
    }

    public String getIdPath() {
        if (this._container == null) {
            throw new NullPointerException(Tapestry.getString("AbstractComponent.null-container", this));
        }
        String containerIdPath = this._container.getIdPath();
        this._idPath = containerIdPath == null ? this.id : containerIdPath + "." + this.id;
        return this._idPath;
    }

    public IPage getPage() {
        return this.page;
    }

    public void setPage(IPage value) {
        if (this.page != null) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractComponent.attempt-to-change-page"));
        }
        this.page = value;
    }

    public ComponentSpecification getSpecification() {
        return this.specification;
    }

    public void setSpecification(ComponentSpecification value) {
        if (this.specification != null) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractComponent.attempt-to-change-spec"));
        }
        this.specification = value;
    }

    public void renderWrapped(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        this.renderBody(writer, cycle);
    }

    public void renderBody(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        int i = 0;
        while (i < this.wrappedCount) {
            this.wrapped[i].render(writer, cycle);
            ++i;
        }
    }

    public void setBinding(String name, IBinding binding) {
        String bindingPropertyName = name + "Binding";
        PropertyInfo info = PropertyFinder.getPropertyInfo(this.getClass(), bindingPropertyName);
        if (info != null && info.isReadWrite() && info.getType().equals(class$net$sf$tapestry$IBinding == null ? (class$net$sf$tapestry$IBinding = AbstractComponent.class$("net.sf.tapestry.IBinding")) : class$net$sf$tapestry$IBinding)) {
            IResourceResolver resolver = this.getPage().getEngine().getResourceResolver();
            OgnlUtils.set(bindingPropertyName, (ClassResolver)resolver, (Object)this, (Object)binding);
            return;
        }
        if (this._bindings == null) {
            this._bindings = new HashMap(5);
        }
        this._bindings.put(name, binding);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('[');
        buffer.append(this.getExtendedId());
        buffer.append(']');
        return buffer.toString();
    }

    public Map getComponents() {
        if (this._components == null) {
            return EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this._components);
    }

    public Map getAssets() {
        if (this._assets == null) {
            return EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this._assets);
    }

    public IAsset getAsset(String name) {
        if (this._assets == null) {
            return null;
        }
        return (IAsset)this._assets.get(name);
    }

    public Collection getBindingNames() {
        if (this._container == null) {
            return null;
        }
        ContainedComponent contained = this._container.getSpecification().getComponent(this.id);
        if (this._bindings == null || this._bindings.size() == 0) {
            return contained.getBindingNames();
        }
        HashSet result = new HashSet(contained.getBindingNames());
        result.addAll(this._bindings.keySet());
        return result;
    }

    public Map getBindings() {
        HashMap<String, IBinding> result = new HashMap<String, IBinding>();
        if (this._bindings != null) {
            result.putAll(this._bindings);
        }
        Iterator i = this.specification.getParameterNames().iterator();
        while (i.hasNext()) {
            IBinding binding;
            String name = (String)i.next();
            if (result.containsKey(name) || (binding = this.getBinding(name)) == null) continue;
            result.put(name, binding);
        }
        return result;
    }

    public ListenerMap getListeners() {
        if (this._listeners == null) {
            this._listeners = new ListenerMap(this);
        }
        return this._listeners;
    }

    public IBeanProvider getBeans() {
        if (this._beans == null) {
            this._beans = new BeanProvider(this);
        }
        return this._beans;
    }

    protected void finishLoad() {
    }

    public final void render(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        try {
            this.prepareForRender(cycle);
            this.renderComponent(writer, cycle);
            Object var4_3 = null;
            this.cleanupAfterRender(cycle);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanupAfterRender(cycle);
            throw throwable;
        }
    }

    protected void prepareForRender(IRequestCycle cycle) throws RequestCycleException {
        if (this._parameterManager == null) {
            this._parameterManager = new ParameterManager(this);
        }
        this._parameterManager.setParameters(cycle);
    }

    protected abstract void renderComponent(IMarkupWriter var1, IRequestCycle var2) throws RequestCycleException;

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._parameterManager.resetParameters(cycle);
    }

    public String getString(String key) {
        if (this._strings == null) {
            this._strings = this.getPage().getEngine().getComponentStringsSource().getStrings(this);
        }
        return this._strings.getString(key);
    }

    public String formatString(String key, Object[] arguments) {
        String format = this.getString(key);
        return MessageFormat.format(format, arguments);
    }

    public String formatString(String key, Object argument) {
        return this.formatString(key, new Object[]{argument});
    }

    public String formatString(String key, Object argument1, Object argument2) {
        return this.formatString(key, new Object[]{argument1, argument2});
    }

    public String formatString(String key, Object argument1, Object argument2, Object argument3) {
        return this.formatString(key, new Object[]{argument1, argument2, argument3});
    }

    public INamespace getNamespace() {
        return this._namespace;
    }

    public void setNamespace(INamespace namespace) {
        this._namespace = namespace;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        OgnlRuntime.setPropertyAccessor((Class)(class$net$sf$tapestry$IBeanProvider == null ? (class$net$sf$tapestry$IBeanProvider = AbstractComponent.class$("net.sf.tapestry.IBeanProvider")) : class$net$sf$tapestry$IBeanProvider), (PropertyAccessor)new BeanProviderPropertyAccessor());
        OgnlRuntime.setPropertyAccessor((Class)(class$net$sf$tapestry$util$prop$IPublicBean == null ? (class$net$sf$tapestry$util$prop$IPublicBean = AbstractComponent.class$("net.sf.tapestry.util.prop.IPublicBean")) : class$net$sf$tapestry$util$prop$IPublicBean), (PropertyAccessor)new PublicBeanPropertyAccessor());
        EMPTY_MAP = Collections.unmodifiableMap(new HashMap(1));
    }
}

