/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.net.URLEncoder;
import java.util.ArrayList;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.Tapestry;

public class Gesture {
    private static final int DEFAULT_HTTP_PORT = 80;
    private IRequestCycle _cycle;
    private String _serviceName;
    private String _serviceContext;
    private String[] _serviceParameters;
    private boolean _stateful;

    public Gesture(IRequestCycle cycle, String serviceName, String[] serviceContext, String[] serviceParameters, boolean stateful) {
        this._cycle = cycle;
        this._serviceName = serviceName;
        this._serviceContext = this.constructContext(serviceContext);
        this._serviceParameters = serviceParameters;
        this._stateful = stateful;
    }

    private String constructContext(String[] serviceContext) {
        int count = Tapestry.size(serviceContext);
        if (count == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < count) {
            if (i > 0) {
                buffer.append('/');
            }
            buffer.append(serviceContext[i]);
            ++i;
        }
        return buffer.toString();
    }

    public String getBareURL() {
        return this.constructURL(new StringBuffer(), false);
    }

    public String getURL() {
        return this.constructURL(new StringBuffer(), true);
    }

    public String getAbsoluteURL() {
        return this.getAbsoluteURL(null, null, 0);
    }

    public String getAbsoluteURL(String scheme, String server, int port) {
        StringBuffer buffer = new StringBuffer();
        RequestContext context = this._cycle.getRequestContext();
        if (scheme == null) {
            scheme = context.getScheme();
        }
        buffer.append(scheme);
        buffer.append("://");
        if (server == null) {
            server = context.getServerName();
        }
        buffer.append(server);
        if (port == 0) {
            port = context.getServerPort();
        }
        if (!scheme.equals("http") || port != 80) {
            buffer.append(':');
            buffer.append(port);
        }
        return this.constructURL(buffer, true);
    }

    private String constructURL(StringBuffer buffer, boolean includeParameters) {
        buffer.append(this._cycle.getEngine().getServletPath());
        if (includeParameters) {
            buffer.append('?');
            buffer.append("service");
            buffer.append('=');
            buffer.append(this._serviceName);
            if (this._serviceContext != null) {
                buffer.append('&');
                buffer.append("context");
                buffer.append('=');
                buffer.append(this._serviceContext);
            }
            int count = Tapestry.size(this._serviceParameters);
            int i = 0;
            while (i < count) {
                buffer.append('&');
                buffer.append("sp");
                buffer.append('=');
                try {
                    String encoded = URLEncoder.encode(this._serviceParameters[i]);
                    buffer.append(encoded);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
            }
        }
        String result = buffer.toString();
        if (this._stateful) {
            result = this._cycle.encodeURL(result);
        }
        return result;
    }

    public String[] getParameterNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("service");
        if (this._serviceContext != null) {
            list.add("context");
        }
        if (Tapestry.size(this._serviceParameters) != 0) {
            list.add("sp");
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name.equals("service")) {
            return new String[]{this._serviceName};
        }
        if (name.equals("context")) {
            return new String[]{this._serviceContext};
        }
        if (name.equals("sp")) {
            return this._serviceParameters;
        }
        throw new IllegalArgumentException(Tapestry.getString("Gesture.unknown-parameter-name", name));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Gesture[");
        buffer.append(this.getBareURL());
        buffer.append(' ');
        int count = Tapestry.size(this._serviceParameters);
        int i = 0;
        while (i < count) {
            if (i == 0) {
                buffer.append(" parameters=");
            } else {
                buffer.append(',');
            }
            buffer.append(this._serviceParameters[i]);
            ++i;
        }
        if (this._stateful) {
            buffer.append(" (stateful)");
        }
        buffer.append(']');
        return buffer.toString();
    }
}

