/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.asset;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.Tapestry;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ContextAsset
implements IAsset {
    private static final Logger LOG = LogManager.getLogger((String)(class$net$sf$tapestry$asset$ContextAsset == null ? (class$net$sf$tapestry$asset$ContextAsset = ContextAsset.class$("net.sf.tapestry.asset.ContextAsset")) : class$net$sf$tapestry$asset$ContextAsset).getName());
    private Map _localizations;
    private String _assetPath;
    static /* synthetic */ Class class$net$sf$tapestry$asset$ContextAsset;

    public ContextAsset(String assetPath) {
        this._assetPath = assetPath;
    }

    public String buildURL(IRequestCycle cycle) {
        Localization localization = this.findLocalization(cycle);
        return localization.URL;
    }

    public InputStream getResourceAsStream(IRequestCycle cycle) {
        return this.getResourceAsStream(cycle, cycle.getPage().getLocale());
    }

    public InputStream getResourceAsStream(IRequestCycle cycle, Locale locale) {
        Localization localization = this.findLocalization(cycle, locale);
        try {
            ServletContext context = cycle.getRequestContext().getServlet().getServletContext();
            URL url = context.getResource(localization.assetPath);
            return url.openStream();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("ContextAsset.resource-missing", this._assetPath), ex);
        }
    }

    private Localization findLocalization(IRequestCycle cycle) {
        return this.findLocalization(cycle, cycle.getPage().getLocale());
    }

    private synchronized Localization findLocalization(IRequestCycle cycle, Locale locale) {
        String language;
        Localization result;
        if (this._localizations == null) {
            this._localizations = new HashMap();
        }
        if ((result = (Localization)this._localizations.get(locale)) != null) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for localization of context resource " + this._assetPath));
        }
        int dotx = this._assetPath.lastIndexOf(46);
        String suffix = this._assetPath.substring(dotx);
        StringBuffer buffer = new StringBuffer(dotx + 30);
        buffer.append(this._assetPath.substring(0, dotx));
        int rawLength = buffer.length();
        int start = 2;
        String country = locale.getCountry();
        if (country.length() > 0) {
            --start;
        }
        if ((language = locale.getLanguage()).length() > 0) {
            --start;
        }
        ServletContext context = cycle.getRequestContext().getServlet().getServletContext();
        String contextPath = cycle.getEngine().getContextPath();
        int i = start;
        while (i < 3) {
            buffer.setLength(rawLength);
            if (i < 2) {
                buffer.append('_');
                buffer.append(language);
            }
            if (i == 0) {
                buffer.append('_');
                buffer.append(country);
            }
            buffer.append(suffix);
            String candidatePath = buffer.toString();
            try {
                URL candidateURL = context.getResource(candidatePath);
                if (candidateURL != null && this.exists(candidateURL)) {
                    result = new Localization(candidatePath, contextPath + candidatePath);
                    this._localizations.put(locale, result);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found " + this._assetPath));
                    }
                    return result;
                }
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            ++i;
        }
        throw new ApplicationRuntimeException(Tapestry.getString("ContextAsset.resource-unavailable", this._assetPath, locale));
    }

    private boolean exists(URL url) {
        InputStream in = null;
        try {
            try {
                in = url.openStream();
                in.read();
                in.close();
                in = null;
            }
            catch (IOException ex) {
                boolean bl = false;
                Object var6_4 = null;
                this.close(in);
                return bl;
            }
            Object var6_3 = null;
            this.close(in);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.close(in);
            throw throwable;
        }
        return true;
    }

    private void close(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ContextAsset[");
        buffer.append(this._assetPath);
        buffer.append(']');
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Localization {
        String assetPath;
        String URL;

        Localization(String assetPath, String URL2) {
            this.assetPath = assetPath;
            this.URL = URL2;
        }
    }
}

