/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.asset;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.Gesture;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IEngineService;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.asset.AssetExternalizer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PrivateAsset
implements IAsset {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$asset$PrivateAsset == null ? (class$net$sf$tapestry$asset$PrivateAsset = PrivateAsset.class$("net.sf.tapestry.asset.PrivateAsset")) : class$net$sf$tapestry$asset$PrivateAsset));
    private AssetExternalizer _externalizer;
    private String _resourcePath;
    private Map _localizations;
    static /* synthetic */ Class class$net$sf$tapestry$asset$PrivateAsset;

    public PrivateAsset(String resourcePath) {
        this._resourcePath = resourcePath;
    }

    public String buildURL(IRequestCycle cycle) {
        String externalURL;
        String localizedResourcePath = this.findLocalization(cycle, cycle.getPage().getLocale());
        if (this._externalizer == null) {
            this._externalizer = AssetExternalizer.get(cycle);
        }
        if ((externalURL = this._externalizer.getURL(localizedResourcePath)) != null) {
            return externalURL;
        }
        Object[] parameters = new String[]{localizedResourcePath};
        IEngineService service = cycle.getEngine().getService("asset");
        Gesture g = service.buildGesture(cycle, null, parameters);
        return g.getURL();
    }

    public InputStream getResourceAsStream(IRequestCycle cycle) {
        return this.getResourceAsStream(cycle, cycle.getPage().getLocale());
    }

    public InputStream getResourceAsStream(IRequestCycle cycle, Locale locale) {
        try {
            IResourceResolver resolver = cycle.getEngine().getResourceResolver();
            URL url = resolver.getResource(this.findLocalization(cycle, locale));
            return url.openStream();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("PrivateAsset.resource-missing", this._resourcePath), ex);
        }
    }

    private synchronized String findLocalization(IRequestCycle cycle, Locale locale) {
        String language;
        String result;
        if (this._localizations == null) {
            this._localizations = new HashMap();
        }
        if ((result = (String)this._localizations.get(locale)) != null) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for localization of private asset " + this._resourcePath + " in locale " + locale.getDisplayName()));
        }
        int dotx = this._resourcePath.lastIndexOf(46);
        String suffix = this._resourcePath.substring(dotx);
        StringBuffer buffer = new StringBuffer(dotx + 30);
        buffer.append(this._resourcePath.substring(0, dotx));
        int rawLength = buffer.length();
        int start = 2;
        String country = locale.getCountry();
        if (country.length() > 0) {
            --start;
        }
        if ((language = locale.getLanguage()).length() > 0) {
            --start;
        }
        IResourceResolver resolver = cycle.getEngine().getResourceResolver();
        int i = start;
        while (i < 3) {
            buffer.setLength(rawLength);
            if (i < 2) {
                buffer.append('_');
                buffer.append(language);
            }
            if (i == 0) {
                buffer.append('_');
                buffer.append(country);
            }
            buffer.append(suffix);
            String candidatePath = buffer.toString();
            if (resolver.getResource(candidatePath) != null) {
                this._localizations.put(locale, candidatePath);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found " + candidatePath));
                }
                return candidatePath;
            }
            ++i;
        }
        throw new ApplicationRuntimeException(Tapestry.getString("PrivateAsset.resource-unavailable", this._resourcePath, locale));
    }

    public String toString() {
        return "PrivateAsset[" + this._resourcePath + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

