/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.binding;

import java.util.Map;
import net.sf.tapestry.BindingException;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.ReadOnlyBindingException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.binding.AbstractBinding;
import net.sf.tapestry.spec.BeanLifecycle;
import net.sf.tapestry.spec.BeanSpecification;
import net.sf.tapestry.util.StringSplitter;
import net.sf.tapestry.util.prop.OgnlUtils;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlException;

public class ExpressionBinding
extends AbstractBinding {
    private IComponent _root;
    private String _expression;
    private boolean _invariant = false;
    private Object _cachedValue;
    private Object _parsedExpression;
    private boolean _initialized;
    private IResourceResolver _resolver;
    private Map _context;

    public ExpressionBinding(IResourceResolver resolver, IComponent root, String expression) {
        this._resolver = resolver;
        this._root = root;
        this._expression = expression;
    }

    public String getExpression() {
        return this._expression;
    }

    public IComponent getRoot() {
        return this._root;
    }

    public Object getObject() {
        this.initialize();
        if (this._invariant) {
            return this._cachedValue;
        }
        return this.resolveProperty();
    }

    private Object resolveProperty() {
        try {
            return Ognl.getValue((Object)this._parsedExpression, (Map)this.getOgnlContext(), (Object)this._root);
        }
        catch (Throwable t) {
            throw new BindingException(Tapestry.getString("ExpressionBinding.unable-to-resolve-expression", this._expression, this._root), this, t);
        }
    }

    private Map getOgnlContext() {
        if (this._context == null) {
            this._context = Ognl.createDefaultContext((Object)this._root, (ClassResolver)this._resolver);
        }
        return this._context;
    }

    public boolean isInvariant() {
        this.initialize();
        return this._invariant;
    }

    public void setBoolean(boolean value) {
        this.setObject(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setInt(int value) {
        this.setObject(new Integer(value));
    }

    public void setDouble(double value) {
        this.setObject(new Double(value));
    }

    public void setString(String value) {
        this.setObject(value);
    }

    private void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        this._parsedExpression = OgnlUtils.getParsedExpression(this._expression);
        if (this.checkForConstant()) {
            return;
        }
        String[] split = new StringSplitter('.').splitToArray(this._expression);
        int count = this.optimizeRootObject(split);
        if (count == split.length) {
            this._expression = null;
            this._parsedExpression = null;
            this._invariant = true;
            this._cachedValue = this._root;
            return;
        }
        this._expression = this.reassemble(count, split);
        this._parsedExpression = OgnlUtils.getParsedExpression(this._expression);
        this.checkForInvariant(count, split);
    }

    private int optimizeRootObject(String[] split) {
        int i = 0;
        while (i < split.length) {
            if (split[i].equals("page")) {
                this._root = this._root.getPage();
            } else if (split[i].equals("container")) {
                this._root = this._root.getContainer();
            } else {
                if (!split[i].equals("components") || i + 1 >= split.length) break;
                this._root = this._root.getComponent(split[i + 1]);
                ++i;
            }
            ++i;
        }
        return i;
    }

    private boolean checkForConstant() {
        try {
            if (Ognl.isConstant((Object)this._parsedExpression, (Map)this.getOgnlContext())) {
                this._invariant = true;
                this._cachedValue = this.resolveProperty();
                return true;
            }
        }
        catch (OgnlException ex) {
            throw new BindingException(Tapestry.getString("ExpressionBinding.unable-to-resolve-expression", this._expression, this._root), this, ex);
        }
        return false;
    }

    private String reassemble(int start, String[] split) {
        int count = split.length - start;
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return split[split.length - 1];
        }
        StringBuffer buffer = new StringBuffer();
        int i = start;
        while (i < split.length) {
            if (i > start) {
                buffer.append('.');
            }
            buffer.append(split[i]);
            ++i;
        }
        return buffer.toString();
    }

    private void checkForInvariant(int start, String[] split) {
        if (split.length - start != 2) {
            return;
        }
        try {
            if (!Ognl.isSimpleNavigationChain((Object)this._parsedExpression, (Map)this.getOgnlContext())) {
                return;
            }
        }
        catch (OgnlException ex) {
            throw new BindingException(Tapestry.getString("ExpressionBinding.unable-to-resolve-expression", this._expression, this._root), this, ex);
        }
        String first = split[start];
        if (first.equals("listeners")) {
            this._invariant = true;
            this._cachedValue = this.resolveProperty();
            return;
        }
        if (first.equals("assets")) {
            String name = split[start + 1];
            this._invariant = true;
            this._cachedValue = this._root.getAsset(name);
            return;
        }
        if (first.equals("beans")) {
            String name = split[start + 1];
            BeanSpecification bs = this._root.getSpecification().getBeanSpecification(name);
            if (bs == null || bs.getLifecycle() != BeanLifecycle.PAGE) {
                return;
            }
            this._invariant = true;
            this._cachedValue = this.resolveProperty();
            return;
        }
        if (first.equals("bindings")) {
            String name = split[start + 1];
            this._invariant = true;
            this._cachedValue = this._root.getBinding(name);
            return;
        }
    }

    public void setObject(Object value) {
        this.initialize();
        if (this._invariant) {
            throw new ReadOnlyBindingException(this);
        }
        try {
            Ognl.setValue((Object)this._parsedExpression, (Map)this.getOgnlContext(), (Object)this._root, (Object)value);
        }
        catch (Throwable ex) {
            throw new BindingException(Tapestry.getString("ExpressionBinding.unable-to-update-expression", this._expression, this._root, value), this, ex);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ExpressionBinding[");
        buffer.append(this._root.getExtendedId());
        if (this._expression != null) {
            buffer.append(' ');
            buffer.append(this._expression);
        }
        if (this._invariant) {
            buffer.append(" cachedValue=");
            buffer.append(this._cachedValue);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public Class getType() {
        return null;
    }
}

