/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.binding;

import java.lang.reflect.Field;
import net.sf.tapestry.BindingException;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.binding.AbstractBinding;

public class FieldBinding
extends AbstractBinding {
    private String fieldName;
    private boolean accessed;
    private Object value;
    private IResourceResolver resolver;

    public FieldBinding(IResourceResolver resolver, String fieldName) {
        this.resolver = resolver;
        this.fieldName = fieldName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("FieldBinding[");
        buffer.append(this.fieldName);
        if (this.accessed) {
            buffer.append(" (");
            buffer.append(this.value);
            buffer.append(')');
        }
        buffer.append(']');
        return buffer.toString();
    }

    public Object getObject() {
        if (!this.accessed) {
            this.accessValue();
        }
        return this.value;
    }

    public Class getType() {
        if (!this.accessed) {
            this.accessValue();
        }
        if (this.value == null) {
            return null;
        }
        return this.value.getClass();
    }

    private void accessValue() {
        Field field;
        Class targetClass;
        int dotx = this.fieldName.lastIndexOf(46);
        if (dotx < 0) {
            throw new BindingException(Tapestry.getString("invalid-field-name", this.fieldName), this);
        }
        String className = this.fieldName.substring(0, dotx);
        String simpleFieldName = this.fieldName.substring(dotx + 1);
        if (className.indexOf(46) < 0) {
            className = "java.lang." + className;
        }
        try {
            targetClass = this.resolver.findClass(className);
        }
        catch (Throwable t) {
            throw new BindingException(Tapestry.getString("unable-to-resolve-class", className), this, t);
        }
        try {
            field = targetClass.getField(simpleFieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new BindingException(Tapestry.getString("field-not-defined", this.fieldName), this, ex);
        }
        try {
            this.value = field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new BindingException(Tapestry.getString("illegal-field-acccess", this.fieldName), this, ex);
        }
        catch (NullPointerException ex) {
            throw new BindingException(Tapestry.getString("field-is-instance", this.fieldName), this, ex);
        }
        this.accessed = true;
    }
}

