/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.components;

import java.util.Iterator;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RenderOnlyPropertyException;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;

public class Foreach
extends AbstractComponent {
    private Object _source;
    private IBinding _valueBinding;
    private IBinding _indexBinding;
    private String _element;
    private Object _value;
    private int _index;
    private boolean _rendering;

    public IBinding getIndexBinding() {
        return this._indexBinding;
    }

    public void setIndexBinding(IBinding value) {
        this._indexBinding = value;
    }

    protected Iterator getSourceData() {
        if (this._source == null) {
            return null;
        }
        return Tapestry.coerceToIterator(this._source);
    }

    public IBinding getValueBinding() {
        return this._valueBinding;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        Iterator dataSource = this.getSourceData();
        if (dataSource == null) {
            return;
        }
        try {
            this._rendering = true;
            this._value = null;
            this._index = 0;
            boolean hasNext = dataSource.hasNext();
            while (hasNext) {
                this._value = dataSource.next();
                hasNext = dataSource.hasNext();
                if (this._indexBinding != null) {
                    this._indexBinding.setInt(this._index);
                }
                if (this._valueBinding != null) {
                    this._valueBinding.setObject(this._value);
                }
                if (this._element != null) {
                    writer.begin(this._element);
                    this.generateAttributes(writer, cycle);
                }
                this.renderBody(writer, cycle);
                if (this._element != null) {
                    writer.end();
                }
                ++this._index;
            }
            Object var6_5 = null;
            this._value = null;
            this._rendering = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._value = null;
            this._rendering = false;
            throw throwable;
        }
    }

    public void setValueBinding(IBinding value) {
        this._valueBinding = value;
    }

    public Object getValue() {
        if (!this._rendering) {
            throw new RenderOnlyPropertyException(this, "value");
        }
        return this._value;
    }

    public String getElement() {
        return this._element;
    }

    public void setElement(String element) {
        this._element = element;
    }

    public Object getSource() {
        return this._source;
    }

    public void setSource(Object source) {
        this._source = source;
    }

    public int getIndex() {
        if (!this._rendering) {
            throw new RenderOnlyPropertyException(this, "index");
        }
        return this._index;
    }
}

