/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.ApplicationServlet;
import net.sf.tapestry.IComponentStringsSource;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IEngineService;
import net.sf.tapestry.IEngineServiceView;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IMonitor;
import net.sf.tapestry.INamespace;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IPageRecorder;
import net.sf.tapestry.IPageSource;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.IScriptSource;
import net.sf.tapestry.ISpecificationSource;
import net.sf.tapestry.ITemplateSource;
import net.sf.tapestry.PageRedirectException;
import net.sf.tapestry.RedirectException;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.ResponseOutputStream;
import net.sf.tapestry.StaleLinkException;
import net.sf.tapestry.StaleSessionException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.DefaultScriptSource;
import net.sf.tapestry.engine.DefaultSpecificationSource;
import net.sf.tapestry.engine.DefaultStringsSource;
import net.sf.tapestry.engine.DefaultTemplateSource;
import net.sf.tapestry.engine.RequestCycle;
import net.sf.tapestry.listener.ListenerMap;
import net.sf.tapestry.pageload.PageSource;
import net.sf.tapestry.spec.IApplicationSpecification;
import net.sf.tapestry.util.exception.ExceptionAnalyzer;
import net.sf.tapestry.util.io.DataSqueezer;
import net.sf.tapestry.util.prop.OgnlUtils;
import ognl.ClassResolver;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractEngine
implements IEngine,
IEngineServiceView,
Externalizable,
HttpSessionBindingListener {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$engine$AbstractEngine == null ? (class$net$sf$tapestry$engine$AbstractEngine = AbstractEngine.class$("net.sf.tapestry.engine.AbstractEngine")) : class$net$sf$tapestry$engine$AbstractEngine));
    private static final long serialVersionUID = 6884834397673817117L;
    private transient String _contextPath;
    private transient String _servletPath;
    private transient String _clientAddress;
    private transient String _sessionId;
    private transient boolean _stateful;
    private transient ListenerMap _listeners;
    private transient boolean _refreshing;
    private transient DataSqueezer _dataSqueezer;
    private Object _visit;
    private Locale _locale;
    private boolean _localeChanged;
    protected transient IApplicationSpecification _specification;
    protected transient ITemplateSource _templateSource;
    protected transient ISpecificationSource _specificationSource;
    private transient IScriptSource _scriptSource;
    protected static final String SCRIPT_SOURCE_NAME = "net.sf.tapestry.ScriptSource";
    protected static final String STRINGS_SOURCE_NAME = "net.sf.tapestry.StringsSource";
    private transient IComponentStringsSource _stringsSource;
    public static final String VISIT_CLASS_PROPERTY_NAME = "net.sf.tapestry.visit-class";
    protected static final String TEMPLATE_SOURCE_NAME = "net.sf.tapestry.TemplateSource";
    protected static final String SPECIFICATION_SOURCE_NAME = "net.sf.tapestry.SpecificationSource";
    protected static final String PAGE_SOURCE_NAME = "net.sf.tapestry.PageSource";
    protected static final String DATA_SQUEEZER_NAME = "net.sf.tapestry.DataSqueezer";
    private transient IPageSource _pageSource;
    private static final boolean _resetServiceEnabled = Boolean.getBoolean("net.sf.tapestry.enable-reset-service");
    private static final boolean _disableCaching = Boolean.getBoolean("net.sf.tapestry.disable-caching");
    private transient IResourceResolver _resolver;
    private transient Map _serviceMap;
    protected static final String SERVICE_MAP_NAME = "net.sf.tapestry.ServiceMap";
    static /* synthetic */ Class class$net$sf$tapestry$engine$AbstractEngine;

    protected void activateExceptionPage(IRequestCycle cycle, ResponseOutputStream output, Throwable cause) throws ServletException {
        try {
            IPage exceptionPage = cycle.getPage("Exception");
            OgnlUtils.set("exception", (ClassResolver)this._resolver, (Object)exceptionPage, (Object)cause);
            cycle.setPage(exceptionPage);
            this.renderResponse(cycle, output);
        }
        catch (Throwable ex) {
            this.reportException(Tapestry.getString("AbstractEngine.unable-to-process-client-request"), cause);
            this.reportException(Tapestry.getString("AbstractEngine.unable-to-present-exception-page"), ex);
            throw new ServletException(ex.getMessage(), ex);
        }
    }

    public void reportException(String reportTitle, Throwable ex) {
        LOG.warn((Object)reportTitle, ex);
        System.err.println("\n\n**********************************************************\n\n");
        System.err.println(reportTitle);
        System.err.println("\n\n      Session id: " + this._sessionId + "\n  Client address: " + this._clientAddress + "\n\nExceptions:\n");
        new ExceptionAnalyzer().reportException(ex, System.err);
        System.err.println("\n**********************************************************\n");
    }

    protected abstract void cleanupAfterRequest(IRequestCycle var1);

    public void extendDescription(StringBuffer buffer) {
        if (this._specification == null) {
            buffer.append(Tapestry.getString("AbstractEngine.unknown-specification"));
        } else {
            buffer.append(this._specification.getName());
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public IMonitor getMonitor(RequestContext context) {
        return null;
    }

    public IPageSource getPageSource() {
        return this._pageSource;
    }

    public IEngineService getService(String name) {
        IEngineService result = (IEngineService)this._serviceMap.get(name);
        if (result == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractEngine.unknown-service", name));
        }
        return result;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public IApplicationSpecification getSpecification() {
        return this._specification;
    }

    public ISpecificationSource getSpecificationSource() {
        return this._specificationSource;
    }

    public ITemplateSource getTemplateSource() {
        return this._templateSource;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._stateful = true;
        String localeName = in.readUTF();
        this._locale = Tapestry.getLocale(localeName);
        this._visit = in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this._locale.toString());
        out.writeObject(this._visit);
    }

    protected void redirect(String pageName, IRequestCycle cycle, ResponseOutputStream out, RequestCycleException exception) throws IOException, RequestCycleException, ServletException {
        out.reset();
        IPage page = cycle.getPage(pageName);
        cycle.setPage(page);
        this.renderResponse(cycle, out);
    }

    public void renderResponse(IRequestCycle cycle, ResponseOutputStream output) throws RequestCycleException, ServletException, IOException {
        boolean discard = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Begin render response.");
        }
        if (this._localeChanged) {
            this._localeChanged = false;
            RequestContext context = cycle.getRequestContext();
            ApplicationServlet servlet = context.getServlet();
            servlet.writeLocaleCookie(this._locale, this, context);
        }
        IPage page = cycle.getPage();
        IMarkupWriter writer = page.getResponseWriter(output);
        output.setContentType(writer.getContentType());
        try {
            cycle.renderPage(writer);
            discard = false;
            Object var9_8 = null;
            if (discard) {
                output.setDiscard(true);
            }
            writer.close();
            if (discard) {
                output.setDiscard(false);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (discard) {
                output.setDiscard(true);
            }
            writer.close();
            if (discard) {
                output.setDiscard(false);
            }
            throw throwable;
        }
    }

    public void restart(IRequestCycle cycle) throws IOException {
        RequestContext context;
        block3: {
            context = cycle.getRequestContext();
            HttpSession session = context.getSession();
            if (session != null) {
                try {
                    session.invalidate();
                }
                catch (IllegalStateException ex) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)"Exception thrown invalidating HttpSession.", (Throwable)ex);
                }
            }
        }
        this._stateful = false;
        String url = context.getAbsoluteURL(this._servletPath);
        context.redirect(url);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean service(RequestContext context) throws ServletException, IOException {
        block45: {
            block39: {
                block44: {
                    block40: {
                        cycle = null;
                        output = null;
                        if (AbstractEngine.LOG.isInfoEnabled()) {
                            AbstractEngine.LOG.info((Object)("Begin service " + context.getRequestURI()));
                        }
                        if (this._specification == null) {
                            this._specification = context.getServlet().getApplicationSpecification();
                        }
                        this._localeChanged = false;
                        if (this._resolver == null) {
                            this._resolver = this._specification.getResourceResolver();
                        }
                        try {
                            this.setupForRequest(context);
                            monitor = this.getMonitor(context);
                            cycle = new RequestCycle(this, context, monitor);
                            output = new ResponseOutputStream(context.getResponse());
                        }
                        catch (Exception ex) {
                            this.reportException(Tapestry.getString("AbstractEngine.unable-to-begin-request"), ex);
                            throw new ServletException(ex.getMessage(), (Throwable)ex);
                        }
                        service = null;
                        try {
                            try {
                                try {
                                    try {
                                        serviceName = this.extractServiceName(context);
                                        if (Tapestry.isNull(serviceName)) {
                                            serviceName = "home";
                                        }
                                        service = this.getService(serviceName);
                                        cycle.setService(service);
                                        if (monitor != null) {
                                            monitor.serviceBegin(service.getName(), context.getRequestURI());
                                        }
                                        var7_10 = service.service(this, cycle, output);
                                        var11_12 = null;
                                        if (monitor != null) {
                                            monitor.serviceEnd(service.getName());
                                        }
                                    }
                                    catch (PageRedirectException ex) {
                                        this.redirect(ex.getTargetPageName(), cycle, output, ex);
                                        var11_13 = null;
                                        if (monitor != null) {
                                            monitor.serviceEnd(service.getName());
                                        }
                                        break block39;
                                    }
                                    catch (RedirectException ex) {
                                        this.redirectOut(cycle, ex);
                                        var11_14 = null;
                                        if (monitor != null) {
                                            monitor.serviceEnd(service.getName());
                                        }
                                        break block39;
                                    }
                                    catch (StaleLinkException ex) {
                                        this.handleStaleLinkException(ex, cycle, output);
                                        var11_15 = null;
                                        if (monitor != null) {
                                            monitor.serviceEnd(service.getName());
                                        }
                                        break block39;
                                    }
                                    catch (StaleSessionException ex) {
                                        this.handleStaleSessionException(ex, cycle, output);
                                        var11_16 = null;
                                        if (monitor != null) {
                                            monitor.serviceEnd(service.getName());
                                        }
                                        break block39;
                                    }
                                }
                                catch (Throwable var10_28) {
                                    var11_17 = null;
                                    if (monitor == null) throw var10_28;
                                    monitor.serviceEnd(service.getName());
                                    throw var10_28;
                                }
                                var13_18 = null;
                                cycle.cleanup();
                                if (output == null) break block40;
                            }
                            catch (Exception ex) {
                                if (monitor != null) {
                                    monitor.serviceException(ex);
                                }
                                output.reset();
                                if (AbstractEngine.LOG.isInfoEnabled()) {
                                    AbstractEngine.LOG.info((Object)"Uncaught exception", (Throwable)ex);
                                }
                                this.activateExceptionPage(cycle, output, ex);
                                var13_20 = null;
                                cycle.cleanup();
                                if (output != null) {
                                    output.forceFlush();
                                }
                                this.cleanupAfterRequest(cycle);
                                if (AbstractEngine._disableCaching) {
                                    try {
                                        this.clearCachedData();
                                    }
                                    catch (Exception ex) {
                                        AbstractEngine.LOG.warn((Object)"Exception thrown while clearing caches.", (Throwable)ex);
                                    }
                                }
                                if (AbstractEngine.LOG.isInfoEnabled() == false) return true;
                                AbstractEngine.LOG.info((Object)"End service");
                                return true;
                            }
                        }
                        catch (Throwable var12_29) {
                            block43: {
                                var13_21 = null;
                                cycle.cleanup();
                                if (output != null) {
                                    output.forceFlush();
                                }
                                this.cleanupAfterRequest(cycle);
                                if (AbstractEngine._disableCaching) {
                                    ** try [egrp 5[TRYBLOCK] [8 : 422->429)] { 
lbl109:
                                    // 1 sources

                                    this.clearCachedData();
                                    break block43;
lbl111:
                                    // 1 sources

                                    catch (Exception ex) {
                                        AbstractEngine.LOG.warn((Object)"Exception thrown while clearing caches.", (Throwable)ex);
                                    }
                                }
                            }
                            if (AbstractEngine.LOG.isInfoEnabled() == false) throw var12_29;
                            AbstractEngine.LOG.info((Object)"End service");
                            throw var12_29;
                        }
                        output.forceFlush();
                    }
                    this.cleanupAfterRequest(cycle);
                    if (AbstractEngine._disableCaching) {
                        ** try [egrp 5[TRYBLOCK] [8 : 422->429)] { 
lbl123:
                        // 1 sources

                        this.clearCachedData();
                        break block44;
lbl125:
                        // 1 sources

                        catch (Exception ex) {
                            AbstractEngine.LOG.warn((Object)"Exception thrown while clearing caches.", (Throwable)ex);
                        }
                    }
                }
                if (AbstractEngine.LOG.isInfoEnabled() == false) return var7_10;
                AbstractEngine.LOG.info((Object)"End service");
                return var7_10;
            }
            var13_19 = null;
            cycle.cleanup();
            if (output != null) {
                output.forceFlush();
            }
            this.cleanupAfterRequest(cycle);
            if (AbstractEngine._disableCaching) {
                ** try [egrp 5[TRYBLOCK] [8 : 422->429)] { 
lbl139:
                // 1 sources

                this.clearCachedData();
                break block45;
lbl141:
                // 1 sources

                catch (Exception ex) {
                    AbstractEngine.LOG.warn((Object)"Exception thrown while clearing caches.", (Throwable)ex);
                }
            }
        }
        if (AbstractEngine.LOG.isInfoEnabled() == false) return true;
        AbstractEngine.LOG.info((Object)"End service");
        return true;
    }

    protected void handleStaleLinkException(StaleLinkException ex, IRequestCycle cycle, ResponseOutputStream output) throws IOException, ServletException, RequestCycleException {
        this.redirect("StaleLink", cycle, output, ex);
    }

    protected void handleStaleSessionException(StaleSessionException ex, IRequestCycle cycle, ResponseOutputStream output) throws IOException, ServletException, RequestCycleException {
        this.redirect("StaleSession", cycle, output, ex);
    }

    public void clearCachedData() {
        this._pageSource.reset();
        this._specificationSource.reset();
        this._templateSource.reset();
        this._scriptSource.reset();
        this._stringsSource.reset();
    }

    public void setLocale(Locale value) {
        if (value == null) {
            throw new IllegalArgumentException("May not change engine locale to null.");
        }
        if (!value.equals(this._locale)) {
            this._locale = value;
            this._localeChanged = true;
        }
    }

    protected void setupForRequest(RequestContext context) {
        String name;
        ApplicationServlet servlet = context.getServlet();
        ServletContext servletContext = servlet.getServletContext();
        HttpServletRequest request = context.getRequest();
        HttpSession session = context.getSession();
        this._sessionId = session != null ? context.getSession().getId() : null;
        this._clientAddress = request.getRemoteHost();
        if (this._clientAddress == null) {
            this._clientAddress = request.getRemoteAddr();
        }
        if (this._servletPath == null) {
            String path = request.getServletPath();
            this._contextPath = request.getContextPath();
            this._servletPath = this._contextPath + path;
        }
        String servletName = context.getServlet().getServletName();
        if (this._templateSource == null) {
            name = "net.sf.tapestry.TemplateSource." + servletName;
            this._templateSource = (ITemplateSource)servletContext.getAttribute(name);
            if (this._templateSource == null) {
                this._templateSource = this.createTemplateSource();
                servletContext.setAttribute(name, (Object)this._templateSource);
            }
        }
        if (this._specificationSource == null) {
            name = "net.sf.tapestry.SpecificationSource." + servletName;
            this._specificationSource = (ISpecificationSource)servletContext.getAttribute(name);
            if (this._specificationSource == null) {
                this._specificationSource = this.createSpecificationSource();
                servletContext.setAttribute(name, (Object)this._specificationSource);
            }
        }
        if (this._pageSource == null) {
            name = "net.sf.tapestry.PageSource." + servletName;
            this._pageSource = (IPageSource)servletContext.getAttribute(name);
            if (this._pageSource == null) {
                this._pageSource = this.createPageSource();
                servletContext.setAttribute(name, (Object)this._pageSource);
            }
        }
        if (this._scriptSource == null) {
            name = "net.sf.tapestry.ScriptSource." + servletName;
            this._scriptSource = (IScriptSource)servletContext.getAttribute(name);
            if (this._scriptSource == null) {
                this._scriptSource = this.createScriptSource();
                servletContext.setAttribute(name, (Object)this._scriptSource);
            }
        }
        if (this._serviceMap == null) {
            name = "net.sf.tapestry.ServiceMap." + servletName;
            this._serviceMap = (Map)servletContext.getAttribute(name);
            if (this._serviceMap == null) {
                this._serviceMap = this.createServiceMap();
                servletContext.setAttribute(name, (Object)this._serviceMap);
            }
        }
        if (this._stringsSource == null) {
            name = "net.sf.tapestry.StringsSource." + servletName;
            this._stringsSource = (IComponentStringsSource)servletContext.getAttribute(name);
            if (this._stringsSource == null) {
                this._stringsSource = this.createComponentStringsSource();
                servletContext.setAttribute(name, (Object)this._stringsSource);
            }
        }
        if (this._dataSqueezer == null) {
            this._dataSqueezer = (DataSqueezer)servletContext.getAttribute(DATA_SQUEEZER_NAME);
            if (this._dataSqueezer == null) {
                this._dataSqueezer = this.createDataSqueezer();
                servletContext.setAttribute(DATA_SQUEEZER_NAME, (Object)this._dataSqueezer);
            }
        }
    }

    public IComponentStringsSource createComponentStringsSource() {
        return new DefaultStringsSource(this.getResourceResolver());
    }

    protected IScriptSource createScriptSource() {
        return new DefaultScriptSource(this.getResourceResolver());
    }

    protected IPageSource createPageSource() {
        return new PageSource(this.getResourceResolver());
    }

    protected ISpecificationSource createSpecificationSource() {
        return new DefaultSpecificationSource(this.getResourceResolver(), this._specification);
    }

    protected ITemplateSource createTemplateSource() {
        return new DefaultTemplateSource(this.getResourceResolver());
    }

    public IResourceResolver getResourceResolver() {
        return this._resolver;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('[');
        this.extendDescription(buffer);
        buffer.append(']');
        return buffer.toString();
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (this._refreshing) {
            return;
        }
        this.cleanupEngine();
    }

    protected void cleanupEngine() {
        Collection activePageNames;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(this + " cleanupEngine()"));
        }
        if ((activePageNames = this.getActivePageNames()).isEmpty()) {
            return;
        }
        ISpecificationSource specSource = this.getSpecificationSource();
        IPageSource source = this.getPageSource();
        RequestContext fakeContext = null;
        try {
            fakeContext = new RequestContext(null, null, null);
        }
        catch (IOException ex) {
            this.reportException(Tapestry.getString("AbstractEngine.unable-to-create-cleanup-context"), ex);
            return;
        }
        RequestCycle fakeCycle = new RequestCycle(this, fakeContext, null);
        Iterator i = activePageNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            try {
                IPage page = source.getPage(fakeCycle, name, null);
                IPageRecorder recorder = this.getPageRecorder(name);
                recorder.rollback(page);
                page.cleanupPage();
            }
            catch (Throwable t) {
                this.reportException(Tapestry.getString("AbstractEngine.unable-to-cleanup-page", name), t);
            }
        }
    }

    public boolean isResetServiceEnabled() {
        return _resetServiceEnabled;
    }

    public abstract Collection getActivePageNames();

    public Object getVisit() {
        return this._visit;
    }

    public Object getVisit(IRequestCycle cycle) {
        if (this._visit == null && cycle != null) {
            cycle.getRequestContext().createSession();
            this._visit = this.createVisit(cycle);
        }
        return this._visit;
    }

    public void setVisit(Object value) {
        this._visit = value;
    }

    public boolean getHasVisit() {
        return this._visit != null;
    }

    protected Object createVisit(IRequestCycle cycle) {
        Object result = null;
        String visitClassName = this._specification.getProperty(VISIT_CLASS_PROPERTY_NAME);
        if (visitClassName == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractEngine.visit-class-property-not-specified", VISIT_CLASS_PROPERTY_NAME));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating visit object as instance of " + visitClassName));
        }
        Class visitClass = this._resolver.findClass(visitClassName);
        try {
            result = visitClass.newInstance();
        }
        catch (Throwable t) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractEngine.unable-to-instantiate-visit", visitClassName), t);
        }
        cycle.getRequestContext().createSession();
        this.setStateful();
        return result;
    }

    public IScriptSource getScriptSource() {
        return this._scriptSource;
    }

    public boolean isStateful() {
        return this._stateful;
    }

    protected void setStateful() {
        this._stateful = true;
    }

    public ListenerMap getListeners() {
        if (this._listeners == null) {
            this._listeners = new ListenerMap(this);
        }
        return this._listeners;
    }

    protected void redirectOut(IRequestCycle cycle, RedirectException ex) throws RequestCycleException {
        this.handleRedirectException(cycle, ex);
    }

    protected void handleRedirectException(IRequestCycle cycle, RedirectException ex) throws RequestCycleException {
        String location = ex.getLocation();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirecting to: " + location));
        }
        RedirectAnalyzer analyzer = new RedirectAnalyzer(location);
        analyzer.process(cycle);
    }

    private Map createServiceMap() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating service map.");
        }
        ISpecificationSource source = this.getSpecificationSource();
        HashMap result = new HashMap();
        this.addServices(source.getFrameworkNamespace(), result);
        this.addServices(source.getApplicationNamespace(), result);
        IResourceResolver resolver = this.getResourceResolver();
        Iterator i = result.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            String className = (String)entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating service " + name + " as instance of " + className));
            }
            Class serviceClass = resolver.findClass(className);
            try {
                IEngineService service = (IEngineService)serviceClass.newInstance();
                String serviceName = service.getName();
                if (!service.getName().equals(name)) {
                    throw new ApplicationRuntimeException(Tapestry.getString("AbstractEngine.service-name-mismatch", name, serviceClass, serviceName));
                }
                entry.setValue(service);
            }
            catch (InstantiationException ex) {
                String message = Tapestry.getString("AbstractEngine.unable-to-instantiate-service", name, className);
                LOG.error((Object)message, (Throwable)ex);
                throw new ApplicationRuntimeException(message, ex);
            }
            catch (IllegalAccessException ex) {
                String message = Tapestry.getString("AbstractEngine.unable-to-instantiate-service", name, className);
                LOG.error((Object)message, (Throwable)ex);
                throw new ApplicationRuntimeException(message, ex);
            }
        }
        return result;
    }

    private void addServices(INamespace namespace, Map map) {
        List names = namespace.getServiceNames();
        int count = names.size();
        int i = 0;
        while (i < count) {
            String name = (String)names.get(i);
            map.put(name, namespace.getServiceClassName(name));
            ++i;
        }
        List namespaceIds = namespace.getChildIds();
        count = namespaceIds.size();
        int i2 = 0;
        while (i2 < count) {
            String id = (String)namespaceIds.get(i2);
            this.addServices(namespace.getChildNamespace(id), map);
            ++i2;
        }
    }

    public IComponentStringsSource getComponentStringsSource() {
        return this._stringsSource;
    }

    public DataSqueezer getDataSqueezer() {
        return this._dataSqueezer;
    }

    public DataSqueezer createDataSqueezer() {
        return new DataSqueezer(this._resolver);
    }

    protected String extractServiceName(RequestContext context) {
        return context.getParameter("service");
    }

    public boolean isRefreshing() {
        return this._refreshing;
    }

    public void setRefreshing(boolean refreshing) {
        this._refreshing = refreshing;
    }

    public abstract IPageRecorder createPageRecorder(String var1, IRequestCycle var2);

    public abstract IPageRecorder getPageRecorder(String var1);

    public abstract void forgetPage(String var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RedirectAnalyzer {
        private IRequestCycle _cycle;
        private boolean _internal;
        private String _location;

        private RedirectAnalyzer(String location) {
            if (Tapestry.isNull(location)) {
                this._location = "/";
                this._internal = true;
                return;
            }
            this._location = location;
            this._internal = !location.startsWith("/") && location.indexOf("://") <= 0;
        }

        public void process(IRequestCycle cycle) throws RequestCycleException {
            RequestContext context = cycle.getRequestContext();
            if (this._internal) {
                this.forward(context);
            } else {
                this.redirect(context);
            }
        }

        private void forward(RequestContext context) throws RequestCycleException {
            HttpServletRequest request = context.getRequest();
            HttpServletResponse response = context.getResponse();
            RequestDispatcher dispatcher = request.getRequestDispatcher("/" + this._location);
            if (dispatcher == null) {
                throw new RequestCycleException(Tapestry.getString("AbstractEngine.unable-to-find-dispatcher", this._location));
            }
            try {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException ex) {
                throw new RequestCycleException(Tapestry.getString("AbstractEngine.unable-to-forward", this._location), null, ex);
            }
            catch (IOException ex) {
                throw new RequestCycleException(Tapestry.getString("AbstractEngine.unable-to-forward", this._location), null, ex);
            }
        }

        private void redirect(RequestContext context) throws RequestCycleException {
            HttpServletResponse response = context.getResponse();
            String finalURL = response.encodeRedirectURL(this._location);
            try {
                response.sendRedirect(finalURL);
            }
            catch (IOException ex) {
                throw new RequestCycleException(Tapestry.getString("AbstractEngine.unable-to-redirect", this._location), null, ex);
            }
        }
    }
}

