/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.IScript;
import net.sf.tapestry.IScriptSource;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.script.ScriptParser;
import net.sf.tapestry.util.xml.DocumentParseException;

public class DefaultScriptSource
implements IScriptSource {
    private IResourceResolver _resolver;
    private Map _cache = new HashMap();
    private static final int MAP_SIZE = 17;

    public DefaultScriptSource(IResourceResolver resolver) {
        this._resolver = resolver;
    }

    public void reset() {
        this._cache.clear();
    }

    public IScript getScript(String resourcePath) {
        IScript result;
        Map map = this._cache;
        synchronized (map) {
            result = (IScript)this._cache.get(resourcePath);
        }
        if (result != null) {
            return result;
        }
        result = this.parse(resourcePath);
        Map map2 = this._cache;
        synchronized (map2) {
            this._cache.put(resourcePath, result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IScript parse(String resourcePath) {
        IScript iScript;
        ScriptParser parser = new ScriptParser(this._resolver);
        InputStream stream = null;
        try {
            try {
                URL url = this._resolver.getResource(resourcePath);
                if (url == null) {
                    throw new ApplicationRuntimeException(Tapestry.getString("DefaultScriptSource.unable-to-find-script", resourcePath));
                }
                stream = url.openStream();
                IScript result = parser.parse(stream, resourcePath);
                stream.close();
                iScript = result;
                Object var8_9 = null;
            }
            catch (DocumentParseException ex) {
                throw new ApplicationRuntimeException(Tapestry.getString("DefaultScriptSource.unable-to-parse-script", resourcePath), ex);
            }
            catch (IOException ex) {
                throw new ApplicationRuntimeException(Tapestry.getString("DefaultScriptSource.unable-to-read-script", resourcePath), ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Tapestry.close(stream);
            throw throwable;
        }
        Tapestry.close(stream);
        return iScript;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("DefaultScriptSource@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        if (this._cache != null) {
            Map map = this._cache;
            synchronized (map) {
                buffer.append(this._cache.keySet());
            }
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

