/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.Gesture;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IDirect;
import net.sf.tapestry.IEngineServiceView;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.ResponseOutputStream;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.AbstractService;

public class DirectService
extends AbstractService {
    public Gesture buildGesture(IRequestCycle cycle, IComponent component, Object[] parameters) {
        IPage componentPage;
        IPage renderPage = cycle.getPage();
        String[] context = renderPage == (componentPage = component.getPage()) ? new String[]{componentPage.getName(), component.getIdPath()} : new String[]{renderPage.getName(), componentPage.getName(), component.getIdPath()};
        return this.assembleGesture(cycle, "direct", context, parameters, true);
    }

    public boolean service(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output) throws RequestCycleException, ServletException, IOException {
        IDirect direct;
        int count = 0;
        RequestContext requestContext = cycle.getRequestContext();
        String[] serviceContext = this.getServiceContext(requestContext);
        if (serviceContext != null) {
            count = serviceContext.length;
        }
        if (count != 2 && count != 3) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractEngine.direct-context-parameters"));
        }
        int i = 0;
        String pageName = serviceContext[i++];
        String componentPageName = count == 2 ? pageName : serviceContext[i++];
        String componentPath = serviceContext[i++];
        IPage page = cycle.getPage(pageName);
        page.validate(cycle);
        cycle.setPage(page);
        IPage componentPage = count == 2 ? page : cycle.getPage(componentPageName);
        IComponent component = componentPage.getNestedComponent(componentPath);
        try {
            direct = (IDirect)component;
        }
        catch (ClassCastException ex) {
            throw new RequestCycleException(Tapestry.getString("AbstractEngine.direct-component-wrong-type", component.getExtendedId()), component, ex);
        }
        Object[] parameters = this.getParameters(cycle);
        cycle.setServiceParameters(parameters);
        direct.trigger(cycle);
        engine.renderResponse(cycle, output);
        return true;
    }

    public String getName() {
        return "direct";
    }
}

